/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.api.PHPPunctuator;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;

@Rule(key="S2010")
public class LogicalWordOperatorUsageCheck
extends PHPSubscriptionCheck {
    public static final String KEY = "S2010";
    public static final String MESSAGE = "Replace \"%s\" with \"%s\".";

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.ALTERNATIVE_CONDITIONAL_AND, (Object)Tree.Kind.ALTERNATIVE_CONDITIONAL_OR);
    }

    public void visitNode(Tree tree) {
        SyntaxToken operator = ((BinaryExpressionTree)tree).operator();
        String replacement = tree.is(new Tree.Kind[]{Tree.Kind.ALTERNATIVE_CONDITIONAL_AND}) ? PHPPunctuator.ANDAND.getValue() : PHPPunctuator.OROR.getValue();
        this.context().newIssue((PHPCheck)this, (Tree)operator, String.format(MESSAGE, operator.text(), replacement));
    }
}

