/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1996")
public class MoreThanOneClassInFileCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1996";
    private static final String MESSAGE = "There are %s%s%sin this file; move all but one of them to other files.";
    private int nbClass = 0;
    private int nbInterface = 0;

    public void visitClassDeclaration(ClassDeclarationTree tree) {
        super.visitClassDeclaration(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS_DECLARATION})) {
            ++this.nbClass;
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.INTERFACE_DECLARATION})) {
            ++this.nbInterface;
        }
    }

    public void visitScript(ScriptTree tree) {
        this.nbClass = 0;
        this.nbInterface = 0;
        super.visitScript(tree);
        if (this.nbClass + this.nbInterface > 1) {
            String independentClasses = this.nbClass > 0 ? this.nbClass + " independent classes " : "";
            String and = this.nbClass > 0 && this.nbInterface > 0 ? "and " : "";
            String indendentInterfaces = this.nbInterface > 0 ? this.nbInterface + " independent interfaces " : "";
            String message = String.format(MESSAGE, independentClasses, and, indendentInterfaces);
            int cost = this.nbClass + this.nbInterface - 1;
            this.context().newFileIssue((PHPCheck)this, message).cost((double)cost);
        }
    }
}

