/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.AbstractStatementsCheck;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.statement.ElseifClauseTree;
import org.sonar.plugins.php.api.tree.statement.ForEachStatementTree;
import org.sonar.plugins.php.api.tree.statement.ForStatementTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;

@Rule(key="S2681")
public class MultilineBlocksCurlyBracesCheck
extends AbstractStatementsCheck {
    public static final String KEY = "S2681";
    private static final String MESSAGE_LOOP = "Only the first line of this %s-line block will be executed in a loop. The rest will execute only once.";
    private static final String MESSAGE_IF = "Only the first line of this %s-line block will be executed conditionally. The rest will execute unconditionally.";

    public void visitNode(Tree tree) {
        List<StatementTree> statements = MultilineBlocksCurlyBracesCheck.getStatements(tree);
        for (int i = 0; i < statements.size() - 1; ++i) {
            StatementTree currentStatement = statements.get(i);
            if (currentStatement.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
                this.checkStatement(MultilineBlocksCurlyBracesCheck.getLastStatement((IfStatementTree)currentStatement), i, statements);
                continue;
            }
            if (currentStatement.is(new Tree.Kind[]{Tree.Kind.FOR_STATEMENT})) {
                this.checkStatement((StatementTree)((ForStatementTree)currentStatement).statements().get(0), i, statements);
                continue;
            }
            if (currentStatement.is(new Tree.Kind[]{Tree.Kind.FOREACH_STATEMENT})) {
                this.checkStatement((StatementTree)((ForEachStatementTree)currentStatement).statements().get(0), i, statements);
                continue;
            }
            if (!currentStatement.is(new Tree.Kind[]{Tree.Kind.WHILE_STATEMENT})) continue;
            this.checkStatement((StatementTree)((WhileStatementTree)currentStatement).statements().get(0), i, statements);
        }
    }

    private static StatementTree getLastStatement(IfStatementTree ifStatement) {
        List elseifClauses;
        IfStatementTree nestedIfStatement;
        if (ifStatement.elseClause() == null && ifStatement.elseifClauses().isEmpty()) {
            return (StatementTree)ifStatement.statements().get(0);
        }
        IfStatementTree statement = ifStatement;
        while ((statement = (nestedIfStatement = statement).elseClause() != null ? (StatementTree)nestedIfStatement.elseClause().statements().get(0) : ((elseifClauses = nestedIfStatement.elseifClauses()).isEmpty() ? (StatementTree)nestedIfStatement.statements().get(0) : (StatementTree)((ElseifClauseTree)elseifClauses.get(elseifClauses.size() - 1)).statements().get(0))).is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
        }
        return statement;
    }

    private void checkStatement(StatementTree firstInnerStatement, int nestingStatementNum, List<StatementTree> statements) {
        if (firstInnerStatement.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            return;
        }
        int firstIndent = MultilineBlocksCurlyBracesCheck.column((Tree)firstInnerStatement);
        ArrayList<StatementTree> statementsWhichShouldBeNested = new ArrayList<StatementTree>();
        for (int i = nestingStatementNum + 1; i < statements.size(); ++i) {
            StatementTree nextStatement = statements.get(i);
            if (nextStatement.is(new Tree.Kind[]{Tree.Kind.INLINE_HTML})) continue;
            if (MultilineBlocksCurlyBracesCheck.column((Tree)nextStatement) != firstIndent) break;
            statementsWhichShouldBeNested.add(nextStatement);
        }
        if (!statementsWhichShouldBeNested.isEmpty()) {
            int firstInnerStatementLine = ((PHPTree)firstInnerStatement).getLine();
            int lastShouldBeNestedLine = ((PHPTree)statementsWhichShouldBeNested.get(statementsWhichShouldBeNested.size() - 1)).getLine();
            int blockSize = lastShouldBeNestedLine - firstInnerStatementLine + 1;
            String message = statements.get(nestingStatementNum).is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT}) ? MESSAGE_IF : MESSAGE_LOOP;
            this.context().newIssue((PHPCheck)this, (Tree)statementsWhichShouldBeNested.get(0), String.format(message, blockSize));
        }
    }

    private static int column(Tree tree) {
        return ((PHPTree)tree).getFirstToken().column();
    }
}

