/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.tree.statement.SwitchCaseClauseTree;
import org.sonar.plugins.php.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPTreeSubscriber;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S128")
public class NonEmptyCaseWithoutBreakCheck
extends PHPVisitorCheck {
    public static final String KEY = "S128";
    private static final String MESSAGE = "End this switch case with an unconditional break, continue, return or throw statement.";

    public void visitSwitchStatement(SwitchStatementTree switchTree) {
        SwitchCaseClauseTree currentClause = null;
        for (SwitchCaseClauseTree nextClause : switchTree.cases()) {
            if (!(currentClause == null || NonEmptyCaseWithoutBreakCheck.isEmpty(currentClause) || NonEmptyCaseWithoutBreakCheck.hasJumpStatement(currentClause) || NonEmptyCaseWithoutBreakCheck.hasNoBreakComment(nextClause))) {
                this.context().newIssue((PHPCheck)this, (Tree)currentClause.caseToken(), (Tree)currentClause.caseSeparatorToken(), MESSAGE);
            }
            currentClause = nextClause;
        }
        super.visitSwitchStatement(switchTree);
    }

    private static boolean hasNoBreakComment(SwitchCaseClauseTree caseClause) {
        return !caseClause.caseToken().trivias().isEmpty();
    }

    private static boolean hasJumpStatement(SwitchCaseClauseTree caseClause) {
        List statements = caseClause.statements();
        if (((StatementTree)statements.get(statements.size() - 1)).is(new Tree.Kind[]{Tree.Kind.BREAK_STATEMENT})) {
            return true;
        }
        return JumpStatementFinder.hasJumpStatement((Tree)caseClause);
    }

    private static boolean isEmpty(SwitchCaseClauseTree caseClause) {
        return caseClause.statements().isEmpty();
    }

    private static class JumpStatementFinder
    extends PHPTreeSubscriber {
        private boolean foundNode = false;

        private JumpStatementFinder() {
        }

        public List<Tree.Kind> nodesToVisit() {
            return ImmutableList.of((Object)Tree.Kind.FUNCTION_CALL, (Object)Tree.Kind.CONTINUE_STATEMENT, (Object)Tree.Kind.THROW_STATEMENT, (Object)Tree.Kind.RETURN_STATEMENT, (Object)Tree.Kind.BREAK_STATEMENT, (Object)Tree.Kind.GOTO_STATEMENT);
        }

        public void visitNode(Tree tree) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.FUNCTION_CALL}) && !CheckUtils.isExitExpression((FunctionCallTree)tree)) {
                return;
            }
            this.foundNode = true;
        }

        public static boolean hasJumpStatement(Tree tree) {
            JumpStatementFinder jumpStatementFinder = new JumpStatementFinder();
            jumpStatementFinder.scanTree(tree);
            return jumpStatementFinder.foundNode;
        }
    }
}

