/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.sonar.check.Rule;
import org.sonar.php.api.CharsetAwareVisitor;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1779")
public class NonLFCharAsEOLCheck
extends PHPVisitorCheck
implements CharsetAwareVisitor {
    public static final String KEY = "S1779";
    private static final String MESSAGE = "Replace all non line feed end of line characters in this file \"%s\" by LF.";
    private Charset charset;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void visitCompilationUnit(CompilationUnitTree tree) {
        File file = this.context().file();
        try (BufferedReader reader = Files.newReader((File)file, (Charset)this.charset);){
            int c;
            while ((c = reader.read()) != -1) {
                if (c != 13 && c != 8232 && c != 8233) continue;
                String message = String.format(MESSAGE, file.getName());
                this.context().newFileIssue((PHPCheck)this, message);
                break;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Check S1779: Can't read the file", e);
        }
    }
}

