/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;

@Rule(key="S122")
public class OneStatementPerLineCheck
extends PHPSubscriptionCheck {
    public static final String KEY = "S122";
    private static final String MESSAGE = "%s statements were found on this line. Reformat the code to have only one statement per line.";
    private final Map<Integer, StatementCount> statementsPerLine = Maps.newHashMap();
    private final Set<Integer> linesWithHtml = Sets.newHashSet();
    private boolean inFunctionExpression = false;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.SCRIPT, (Object)Tree.Kind.DECLARE_STATEMENT, (Object)Tree.Kind.IF_STATEMENT, (Object)Tree.Kind.ALTERNATIVE_IF_STATEMENT, (Object)Tree.Kind.FOREACH_STATEMENT, (Object)Tree.Kind.ALTERNATIVE_FOREACH_STATEMENT, (Object)Tree.Kind.FOR_STATEMENT, (Object)Tree.Kind.ALTERNATIVE_FOR_STATEMENT, (Object)Tree.Kind.NAMESPACE_STATEMENT, (Object)Tree.Kind.WHILE_STATEMENT, (Object)Tree.Kind.BREAK_STATEMENT, (Object)Tree.Kind.CLASS_DECLARATION, (Object[])new Tree.Kind[]{Tree.Kind.TRAIT_DECLARATION, Tree.Kind.INTERFACE_DECLARATION, Tree.Kind.CONSTANT_DECLARATION, Tree.Kind.CONTINUE_STATEMENT, Tree.Kind.DO_WHILE_STATEMENT, Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.GLOBAL_STATEMENT, Tree.Kind.GOTO_STATEMENT, Tree.Kind.INLINE_HTML_TOKEN, Tree.Kind.RETURN_STATEMENT, Tree.Kind.STATIC_STATEMENT, Tree.Kind.SWITCH_STATEMENT, Tree.Kind.THROW_STATEMENT, Tree.Kind.TRY_STATEMENT, Tree.Kind.UNSET_VARIABLE_STATEMENT, Tree.Kind.USE_STATEMENT, Tree.Kind.YIELD_STATEMENT});
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.SCRIPT})) {
            this.statementsPerLine.clear();
            this.linesWithHtml.clear();
            this.inFunctionExpression = false;
            return;
        }
        int line = OneStatementPerLineCheck.line(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.INLINE_HTML_TOKEN})) {
            this.linesWithHtml.add(line);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION})) {
            if (this.statementsPerLine.containsKey(line)) {
                ++this.statementsPerLine.get((Object)Integer.valueOf((int)line)).nbFunctionExpression;
                this.inFunctionExpression = true;
            }
        } else {
            if (!this.statementsPerLine.containsKey(line)) {
                this.statementsPerLine.put(line, new StatementCount());
            } else if (this.inFunctionExpression) {
                ++this.statementsPerLine.get((Object)Integer.valueOf((int)line)).nbNestedStatement;
            }
            if (!this.inFunctionExpression) {
                ++this.statementsPerLine.get((Object)Integer.valueOf((int)line)).nbStatement;
            }
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION}) && this.statementsPerLine.containsKey(OneStatementPerLineCheck.line(tree))) {
            this.inFunctionExpression = false;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.SCRIPT})) {
            this.finish();
        }
    }

    private void finish() {
        for (Map.Entry<Integer, StatementCount> statementsAtLine : this.statementsPerLine.entrySet()) {
            Integer line = statementsAtLine.getKey();
            if (this.linesWithHtml.contains(line)) continue;
            StatementCount stmtCount = statementsAtLine.getValue();
            if (stmtCount.nbStatement <= 1 && stmtCount.nbFunctionExpression <= 1 && stmtCount.nbNestedStatement <= 1) continue;
            String message = String.format(MESSAGE, stmtCount.nbStatement + stmtCount.nbNestedStatement);
            this.context().newLineIssue((PHPCheck)this, line.intValue(), message);
        }
    }

    private static int line(Tree tree) {
        return ((PHPTree)tree).getLine();
    }

    private static class StatementCount {
        int nbStatement = 0;
        int nbFunctionExpression = 0;
        int nbNestedStatement = 0;

        private StatementCount() {
        }
    }
}

