/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassMemberTree;
import org.sonar.plugins.php.api.tree.declaration.ClassTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ParameterTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.tree.statement.BlockTree;
import org.sonar.plugins.php.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.php.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1185")
public class OverridingMethodSimplyCallParentCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1185";
    private static final String MESSAGE = "Remove this method \"%s\" to simply inherit it.";

    public void visitClassDeclaration(ClassDeclarationTree tree) {
        super.visitClassDeclaration(tree);
        this.visitClass((ClassTree)tree);
    }

    public void visitAnonymousClass(AnonymousClassTree tree) {
        super.visitAnonymousClass(tree);
        this.visitClass((ClassTree)tree);
    }

    private void visitClass(ClassTree tree) {
        if (tree.superClass() != null) {
            String superClass = tree.superClass().fullName();
            for (ClassMemberTree member : tree.members()) {
                if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD_DECLARATION})) continue;
                this.checkMethod((MethodDeclarationTree)member, superClass);
            }
        }
    }

    private void checkMethod(MethodDeclarationTree method, String superClass) {
        BlockTree blockTree;
        if (method.body().is(new Tree.Kind[]{Tree.Kind.BLOCK}) && (blockTree = (BlockTree)method.body()).statements().size() == 1) {
            StatementTree statementTree = (StatementTree)blockTree.statements().get(0);
            ExpressionTree expressionTree = null;
            if (statementTree.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT})) {
                expressionTree = ((ExpressionStatementTree)statementTree).expression();
            } else if (statementTree.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
                expressionTree = ((ReturnStatementTree)statementTree).expression();
            }
            this.checkExpression(expressionTree, method, superClass);
        }
    }

    private void checkExpression(@Nullable ExpressionTree expressionTree, MethodDeclarationTree method, String superClass) {
        FunctionCallTree functionCallTree;
        if (expressionTree != null && expressionTree.is(new Tree.Kind[]{Tree.Kind.FUNCTION_CALL}) && (functionCallTree = (FunctionCallTree)expressionTree).callee().is(new Tree.Kind[]{Tree.Kind.CLASS_MEMBER_ACCESS})) {
            MemberAccessTree memberAccessTree = (MemberAccessTree)functionCallTree.callee();
            String methodName = method.name().text();
            boolean sameMethodName = memberAccessTree.member().toString().equals(methodName);
            if (OverridingMethodSimplyCallParentCheck.isSuperClass(memberAccessTree.object(), superClass) && sameMethodName && OverridingMethodSimplyCallParentCheck.sameArguments(functionCallTree, method)) {
                String message = String.format(MESSAGE, methodName);
                this.context().newIssue((PHPCheck)this, (Tree)method.name(), message);
            }
        }
    }

    private static boolean sameArguments(FunctionCallTree functionCallTree, MethodDeclarationTree method) {
        ArrayList<String> argumentNames = new ArrayList<String>();
        for (ExpressionTree argument : functionCallTree.arguments()) {
            if (!argument.is(new Tree.Kind[]{Tree.Kind.VARIABLE_IDENTIFIER})) {
                return false;
            }
            argumentNames.add(((VariableIdentifierTree)argument).variableExpression().text());
        }
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (ParameterTree parameter : method.parameters().parameters()) {
            parameterNames.add(parameter.variableIdentifier().variableExpression().text());
        }
        return argumentNames.equals(parameterNames);
    }

    private static boolean isSuperClass(ExpressionTree tree, String superClass) {
        String str = tree.toString();
        return superClass.equalsIgnoreCase(str) || "parent".equalsIgnoreCase(str);
    }
}

