/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.FunctionUsageCheck;
import org.sonar.plugins.php.api.tree.SeparatedList;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;

@Rule(key="S2001")
public class PHP5DeprecatedFunctionUsageCheck
extends FunctionUsageCheck {
    public static final String KEY = "S2001";
    private static final String MESSAGE_SET_LOCAL_ARG = "Use the \"%s\" constant instead of a string literal.";
    private static final String MESSAGE_WITH_REPLACEMENT = "Replace this \"%s()\" call with a call to \"%s\".";
    private static final String MESSAGE_WITHOUT_REPLACEMENT = "Remove this \"%s()\" call.";
    private static final String SESSION = "$_SESSION";
    private static final ImmutableMap<String, String> NEW_BY_DEPRECATED_FUNCTIONS = ImmutableMap.builder().put((Object)"call_user_method", (Object)"call_user_func()").put((Object)"call_user_method_array", (Object)"call_user_func_array()").put((Object)"define_syslog_variables", (Object)"").put((Object)"dl", (Object)"").put((Object)"ereg", (Object)"preg_match()").put((Object)"ereg_replace", (Object)"preg_replace()").put((Object)"eregi", (Object)"preg_match() with 'i' modifier").put((Object)"eregi_replace", (Object)"preg_replace() with 'i' modifier").put((Object)"set_magic_quotes_runtime", (Object)"").put((Object)"magic_quotes_runtime", (Object)"").put((Object)"session_register", (Object)"$_SESSION").put((Object)"session_unregister", (Object)"$_SESSION").put((Object)"session_is_registered", (Object)"$_SESSION").put((Object)"set_socket_blocking", (Object)"stream_set_blocking").put((Object)"split", (Object)"preg_split").put((Object)"spliti", (Object)"preg_split").put((Object)"sql_regcase", (Object)"").put((Object)"mysql_db_query", (Object)"mysql_select_db() and mysql_query()").put((Object)"mysql_escape_string", (Object)"mysql_real_escape_string").build();
    private static final String SET_LOCALE_FUNCTION = "setlocale";
    private static final ImmutableSet<String> LOCALE_CATEGORY_CONSTANTS = ImmutableSet.of((Object)"LC_ALL", (Object)"LC_COLLATE", (Object)"LC_CTYPE", (Object)"LC_MONETARY", (Object)"LC_NUMERIC", (Object)"LC_TIME", (Object[])new String[]{"LC_MESSAGES"});

    @Override
    protected ImmutableSet<String> functionNames() {
        return ImmutableSet.builder().addAll((Iterable)NEW_BY_DEPRECATED_FUNCTIONS.keySet()).add((Object)SET_LOCALE_FUNCTION).build();
    }

    @Override
    protected void createIssue(FunctionCallTree tree) {
        String functionName = ((NamespaceNameTree)tree.callee()).qualifiedName();
        if (SET_LOCALE_FUNCTION.equals(functionName)) {
            this.checkLocalCategoryArgument((SeparatedList<ExpressionTree>)tree.arguments());
        } else {
            this.context().newIssue((PHPCheck)this, (Tree)tree.callee(), PHP5DeprecatedFunctionUsageCheck.buildMessage(functionName));
        }
    }

    private static String buildMessage(String functionName) {
        String replacement = (String)NEW_BY_DEPRECATED_FUNCTIONS.get((Object)functionName);
        return replacement.isEmpty() ? String.format(MESSAGE_WITHOUT_REPLACEMENT, functionName) : String.format(MESSAGE_WITH_REPLACEMENT, functionName, replacement);
    }

    private void checkLocalCategoryArgument(SeparatedList<ExpressionTree> arguments) {
        String firstArg;
        String localCategory;
        if (!arguments.isEmpty() && ((ExpressionTree)arguments.get(0)).is(new Tree.Kind[]{Tree.Kind.REGULAR_STRING_LITERAL}) && LOCALE_CATEGORY_CONSTANTS.contains((Object)(localCategory = (firstArg = ((LiteralTree)arguments.get(0)).value()).substring(1, firstArg.length() - 1)))) {
            this.context().newIssue((PHPCheck)this, (Tree)arguments.get(0), String.format(MESSAGE_SET_LOCAL_ARG, localCategory));
        }
    }
}

