/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.php.api.PHPKeyword;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassMemberTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;

@Rule(key="S1990")
public class RedundantFinalCheck
extends PHPSubscriptionCheck {
    public static final String KEY = "S1990";
    private static final String MESSAGE = "Remove this \"final\" modifier.";

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS_DECLARATION);
    }

    public void visitNode(Tree tree) {
        ClassDeclarationTree classDeclaration = (ClassDeclarationTree)tree;
        if (RedundantFinalCheck.isFinalModifier(classDeclaration.modifierToken())) {
            for (ClassMemberTree classMember : classDeclaration.members()) {
                this.checkClassMember(classMember);
            }
        }
    }

    private void checkClassMember(ClassMemberTree classMember) {
        SyntaxToken finalModifier;
        if (classMember.is(new Tree.Kind[]{Tree.Kind.METHOD_DECLARATION}) && (finalModifier = RedundantFinalCheck.getFinalModifier((MethodDeclarationTree)classMember)) != null) {
            this.context().newIssue((PHPCheck)this, (Tree)finalModifier, MESSAGE);
        }
    }

    @Nullable
    private static SyntaxToken getFinalModifier(MethodDeclarationTree methodDeclaration) {
        for (SyntaxToken modifier : methodDeclaration.modifiers()) {
            if (!RedundantFinalCheck.isFinalModifier(modifier)) continue;
            return modifier;
        }
        return null;
    }

    private static boolean isFinalModifier(@Nullable SyntaxToken modifier) {
        return modifier != null && PHPKeyword.FINAL.getValue().equalsIgnoreCase(modifier.text());
    }
}

