/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.statement.BlockTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1126")
public class ReturnOfBooleanExpressionCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1126";
    private static final String MESSAGE = "Replace this \"if-then-else\" statement by a single \"return\" statement.";

    public void visitIfStatement(IfStatementTree tree) {
        super.visitIfStatement(tree);
        if (!tree.elseifClauses().isEmpty() || tree.elseClause() == null) {
            return;
        }
        if (ReturnOfBooleanExpressionCheck.returnsBoolean(ReturnOfBooleanExpressionCheck.getSingleStatement(tree.statements())) && ReturnOfBooleanExpressionCheck.returnsBoolean(ReturnOfBooleanExpressionCheck.getSingleStatement(tree.elseClause().statements()))) {
            this.context().newIssue((PHPCheck)this, (Tree)tree.ifToken(), (Tree)tree.condition(), MESSAGE);
        }
    }

    private static boolean returnsBoolean(@Nullable StatementTree statement) {
        ReturnStatementTree returnStatement;
        return statement != null && statement.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT}) && (returnStatement = (ReturnStatementTree)statement).expression() != null && returnStatement.expression().is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL});
    }

    @Nullable
    private static StatementTree getSingleStatement(List<StatementTree> statements) {
        if (statements.size() == 1) {
            if (statements.get(0).is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
                List blockStatements = ((BlockTree)statements.get(0)).statements();
                if (blockStatements.size() == 1) {
                    return (StatementTree)blockStatements.get(0);
                }
            } else {
                return statements.get(0);
            }
        }
        return null;
    }
}

