/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.TokenVisitor;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.BlockTree;
import org.sonar.plugins.php.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.php.api.tree.statement.UseTraitDeclarationTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1109")
public class RightCurlyBraceStartsLineCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1109";
    private static final String MESSAGE = "Move this closing curly brace to the next line.";

    public void visitBlock(BlockTree tree) {
        super.visitBlock(tree);
        SyntaxToken prevToken = tree.openCurlyBraceToken();
        List statements = tree.statements();
        if (!statements.isEmpty()) {
            prevToken = ((PHPTree)statements.get(statements.size() - 1)).getLastToken();
        }
        this.checkCloseCurlyBrace(tree.closeCurlyBraceToken(), tree.openCurlyBraceToken(), prevToken);
    }

    public void visitUseTraitDeclaration(UseTraitDeclarationTree tree) {
        super.visitUseTraitDeclaration(tree);
        if (tree.openCurlyBraceToken() != null) {
            this.checkCloseCurlyBrace(tree.closeCurlyBraceToken(), tree.openCurlyBraceToken(), new TokenVisitor((Tree)tree).prevToken(tree.closeCurlyBraceToken()));
        }
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        super.visitSwitchStatement(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.SWITCH_STATEMENT})) {
            this.checkCloseCurlyBrace(tree.closeCurlyBraceToken(), tree.openCurlyBraceToken(), new TokenVisitor((Tree)tree).prevToken(tree.closeCurlyBraceToken()));
        }
    }

    public void visitClassDeclaration(ClassDeclarationTree tree) {
        super.visitClassDeclaration(tree);
        this.checkClass((ClassTree)tree);
    }

    public void visitAnonymousClass(AnonymousClassTree tree) {
        super.visitAnonymousClass(tree);
        this.checkClass((ClassTree)tree);
    }

    private void checkClass(ClassTree tree) {
        this.checkCloseCurlyBrace(tree.closeCurlyBraceToken(), tree.openCurlyBraceToken(), new TokenVisitor((Tree)tree).prevToken(tree.closeCurlyBraceToken()));
    }

    private void checkCloseCurlyBrace(SyntaxToken rBrace, SyntaxToken lBrace, SyntaxToken prevToken) {
        int rightBraceLine = rBrace.line();
        if (rightBraceLine == lBrace.line()) {
            return;
        }
        if (rightBraceLine == prevToken.line()) {
            this.context().newIssue((PHPCheck)this, (Tree)rBrace, MESSAGE);
        }
    }
}

