/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.php.checks.utils.Equality;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1656")
public class SelfAssignmentCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1656";
    private static final String MESSAGE = "Remove or correct this useless self-assignment";

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        super.visitAssignmentExpression(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT, Tree.Kind.ASSIGNMENT_BY_REFERENCE})) {
            this.check(tree.variable(), tree.value());
        }
    }

    private void check(ExpressionTree lhs, ExpressionTree rhs) {
        if (Equality.areSyntacticallyEquivalent((Tree)lhs, (Tree)rhs)) {
            this.context().newIssue((PHPCheck)this, (Tree)lhs, (Tree)rhs, MESSAGE);
        }
    }
}

