/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassMemberTree;
import org.sonar.plugins.php.api.tree.declaration.ClassPropertyDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.IdentifierTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2037")
public class SelfKeywordUsageCheck
extends PHPVisitorCheck {
    public static final String KEY = "S2037";
    private static final String MESSAGE = "Use \"static\" keyword instead of \"self\".";
    private Deque<Boolean> isFinalClassStack = new ArrayDeque<Boolean>();
    private Deque<Set<String>> finalOrPrivateMethodsStack = new ArrayDeque<Set<String>>();
    private Deque<Set<String>> privatePropertiesStack = new ArrayDeque<Set<String>>();

    public void visitClassDeclaration(ClassDeclarationTree tree) {
        this.isFinalClassStack.addLast(SelfKeywordUsageCheck.isFinalClass(tree));
        this.finalOrPrivateMethodsStack.addLast(SelfKeywordUsageCheck.getFinalOrPrivateMethods(tree));
        this.privatePropertiesStack.addLast(SelfKeywordUsageCheck.getPrivateProperties(tree));
        super.visitClassDeclaration(tree);
        this.isFinalClassStack.removeLast();
        this.finalOrPrivateMethodsStack.removeLast();
        this.privatePropertiesStack.removeLast();
    }

    private static Set<String> getFinalOrPrivateMethods(ClassDeclarationTree tree) {
        HashSet<String> finalOrPrivateMethods = new HashSet<String>();
        for (ClassMemberTree classMemberTree : tree.members()) {
            MethodDeclarationTree methodDeclaration;
            List modifiers;
            if (!classMemberTree.is(new Tree.Kind[]{Tree.Kind.METHOD_DECLARATION}) || !CheckUtils.hasModifier(modifiers = (methodDeclaration = (MethodDeclarationTree)classMemberTree).modifiers(), "final") && !CheckUtils.hasModifier(modifiers, "private")) continue;
            finalOrPrivateMethods.add(methodDeclaration.name().text());
        }
        return finalOrPrivateMethods;
    }

    private static Set<String> getPrivateProperties(ClassDeclarationTree tree) {
        HashSet<String> privateProperties = new HashSet<String>();
        for (ClassMemberTree classMemberTree : tree.members()) {
            ClassPropertyDeclarationTree propertyDeclaration;
            List modifiers;
            if (!classMemberTree.is(new Tree.Kind[]{Tree.Kind.CLASS_PROPERTY_DECLARATION}) || !CheckUtils.hasModifier(modifiers = (propertyDeclaration = (ClassPropertyDeclarationTree)classMemberTree).modifierTokens(), "private")) continue;
            propertyDeclaration.declarations().forEach(varDec -> privateProperties.add(varDec.identifier().text()));
        }
        return privateProperties;
    }

    private static boolean isFinalClass(ClassDeclarationTree tree) {
        return tree.modifierToken() != null && "final".equals(tree.modifierToken().text());
    }

    public void visitClassPropertyDeclaration(ClassPropertyDeclarationTree tree) {
    }

    public void visitMemberAccess(MemberAccessTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS_MEMBER_ACCESS}) && "self".equals(tree.object().toString()) && !this.isException(tree)) {
            this.context().newIssue((PHPCheck)this, (Tree)tree.object(), MESSAGE);
        }
        super.visitMemberAccess(tree);
    }

    private boolean isException(MemberAccessTree tree) {
        return !this.isFinalClassStack.isEmpty() && (this.isFinalClassStack.getLast() != false || this.isFinalOrPrivateMethod(tree.member()) || this.isPrivateProperty(tree.member()));
    }

    private boolean isFinalOrPrivateMethod(Tree member) {
        return member.is(new Tree.Kind[]{Tree.Kind.NAME_IDENTIFIER}) && this.finalOrPrivateMethodsStack.getLast().contains(((NameIdentifierTree)member).text());
    }

    private boolean isPrivateProperty(Tree member) {
        return member.is(new Tree.Kind[]{Tree.Kind.VARIABLE_IDENTIFIER}) && this.privatePropertiesStack.getLast().contains(((IdentifierTree)member).text());
    }
}

