/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.FunctionUsageCheck;
import org.sonar.php.ini.BasePhpIniIssue;
import org.sonar.php.ini.PhpIniCheck;
import org.sonar.php.ini.PhpIniIssue;
import org.sonar.php.ini.tree.Directive;
import org.sonar.php.ini.tree.PhpIniFile;
import org.sonar.plugins.php.api.tree.SeparatedList;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;

@Rule(key="S3332")
public class SessionCookiePersistenceCheck
extends FunctionUsageCheck
implements PhpIniCheck {
    private static final String PHP_INI_MESSAGE = "Configure \"session.cookie_lifetime\" to 0.";
    private static final String PHP_CODE_MESSAGE = "Pass \"0\" as first argument.";

    public List<PhpIniIssue> analyze(PhpIniFile phpIniFile) {
        ArrayList<PhpIniIssue> issues = new ArrayList<PhpIniIssue>();
        for (Directive directive : phpIniFile.directivesForName("session.cookie_lifetime")) {
            String value = directive.value().text();
            if ("0".equals(value) || "\"0\"".equals(value)) continue;
            issues.add(BasePhpIniIssue.newIssue((String)PHP_INI_MESSAGE).line(directive.name().line()));
        }
        return issues;
    }

    @Override
    protected ImmutableSet<String> functionNames() {
        return ImmutableSet.of((Object)"session_set_cookie_params");
    }

    @Override
    protected void createIssue(FunctionCallTree functionCall) {
        LiteralTree literal;
        ExpressionTree firstArgument;
        SeparatedList arguments = functionCall.arguments();
        if (!arguments.isEmpty() && (firstArgument = (ExpressionTree)arguments.get(0)).is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL}) && !"0".equals((literal = (LiteralTree)firstArgument).value())) {
            this.context().newIssue((PHPCheck)this, (Tree)firstArgument, PHP_CODE_MESSAGE);
        }
    }
}

