/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.SwitchCaseClauseTree;
import org.sonar.plugins.php.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1151")
public class SwitchCaseTooBigCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1151";
    private static final String MESSAGE = "Reduce this \"switch/case\" number of lines from %s to at most %s, for example by extracting code into function.";
    public static final int DEFAULT = 10;
    @RuleProperty(key="max", defaultValue="10")
    int max = 10;

    public void visitSwitchStatement(SwitchStatementTree tree) {
        SwitchCaseClauseTree previousClause = null;
        for (SwitchCaseClauseTree clause : tree.cases()) {
            if (previousClause != null) {
                this.checkCaseClause(previousClause, clause.caseToken().line());
            }
            previousClause = clause;
        }
        if (previousClause != null) {
            SyntaxToken nextToken = tree.closeCurlyBraceToken() == null ? tree.endswitchToken() : tree.closeCurlyBraceToken();
            this.checkCaseClause(previousClause, nextToken.line());
        }
        super.visitSwitchStatement(tree);
    }

    private void checkCaseClause(SwitchCaseClauseTree clause, int nextNodeLine) {
        int lines = nextNodeLine - clause.caseToken().line();
        if (lines > this.max) {
            this.context().newIssue((PHPCheck)this, (Tree)clause.caseToken(), String.format(MESSAGE, lines, this.max));
        }
    }
}

