/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.api.CharsetAwareVisitor;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S105")
public class TabCharacterCheck
extends PHPVisitorCheck
implements CharsetAwareVisitor {
    public static final String KEY = "S105";
    private static final String MESSAGE = "Replace all tab characters in this file by sequences of white-spaces.";
    private Charset charset;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void visitCompilationUnit(CompilationUnitTree tree) {
        List lines;
        try {
            lines = Files.readLines((File)this.context().file(), (Charset)this.charset);
        }
        catch (IOException e) {
            throw new IllegalStateException("Check S105: Can't read the file", e);
        }
        for (String line : lines) {
            if (!line.contains("\t")) continue;
            this.context().newFileIssue((PHPCheck)this, MESSAGE);
            break;
        }
    }
}

