/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.api.PHPKeyword;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassMemberTree;
import org.sonar.plugins.php.api.tree.declaration.ClassPropertyDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1820")
public class TooManyFieldsInClassCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1820";
    private static final String MESSAGE = "Refactor this class so it has no more than %s%s fields, rather than the %s it currently has.";
    public static final int DEFAULT_MAX = 20;
    public static final boolean DEFAULT_COUNT_NON_PUBLIC = true;
    @RuleProperty(key="maximumFieldThreshold", defaultValue="20")
    int maximumFieldThreshold = 20;
    @RuleProperty(key="countNonpublicFields", defaultValue="true", type="BOOLEAN")
    boolean countNonpublicFields = true;

    public void visitClassDeclaration(ClassDeclarationTree tree) {
        super.visitClassDeclaration(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS_DECLARATION})) {
            this.visitClass((ClassTree)tree);
        }
    }

    private void visitClass(ClassTree tree) {
        int nbFields = this.getNumberOfFields(tree);
        if (nbFields > this.maximumFieldThreshold) {
            String message = String.format(MESSAGE, this.maximumFieldThreshold, this.countNonpublicFields ? "" : " public", nbFields);
            this.context().newIssue((PHPCheck)this, (Tree)tree.classToken(), message);
        }
    }

    public void visitAnonymousClass(AnonymousClassTree tree) {
        super.visitAnonymousClass(tree);
        this.visitClass((ClassTree)tree);
    }

    private int getNumberOfFields(ClassTree tree) {
        List<ClassPropertyDeclarationTree> fields = TooManyFieldsInClassCheck.getClassFields(tree);
        int nbFields = fields.size();
        if (!this.countNonpublicFields) {
            nbFields -= TooManyFieldsInClassCheck.getNumberOfNonPublicFields(fields);
        }
        return nbFields;
    }

    private static List<ClassPropertyDeclarationTree> getClassFields(ClassTree classDeclaration) {
        ArrayList fields = Lists.newArrayList();
        for (ClassMemberTree classMember : classDeclaration.members()) {
            if (!classMember.is(new Tree.Kind[]{Tree.Kind.CLASS_PROPERTY_DECLARATION, Tree.Kind.CLASS_CONSTANT_PROPERTY_DECLARATION})) continue;
            fields.add((ClassPropertyDeclarationTree)classMember);
        }
        return fields;
    }

    private static int getNumberOfNonPublicFields(List<ClassPropertyDeclarationTree> fields) {
        int nbNonPublicFields = 0;
        for (ClassPropertyDeclarationTree field : fields) {
            if (!field.is(new Tree.Kind[]{Tree.Kind.CLASS_PROPERTY_DECLARATION}) || !TooManyFieldsInClassCheck.isNonPublic(field.modifierTokens())) continue;
            ++nbNonPublicFields;
        }
        return nbNonPublicFields;
    }

    private static boolean isNonPublic(List<SyntaxToken> modifiers) {
        for (SyntaxToken modifierToken : modifiers) {
            String modifier = modifierToken.text();
            if (PHPKeyword.VAR.getValue().equals(modifier) || !PHPKeyword.PROTECTED.getValue().equals(modifier) && !PHPKeyword.PRIVATE.getValue().equals(modifier)) continue;
            return true;
        }
        return false;
    }
}

