/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S107")
public class TooManyFunctionParametersCheck
extends PHPVisitorCheck {
    public static final String KEY = "S107";
    private static final String MESSAGE = "This function has %s parameters, which is greater than the %s authorized.";
    public static final int DEFAULT_MAX = 7;
    public static final int DEFAULT_CONSTRUCTOR_MAX = 7;
    @RuleProperty(key="max", defaultValue="7")
    int max = 7;
    @RuleProperty(key="constructorMax", defaultValue="7")
    int constructorMax = 7;
    private ClassTree classTree = null;

    public void visitParameterList(ParameterListTree parameterList) {
        int maxValue;
        int numberOfParameters = parameterList.parameters().size();
        int n = maxValue = this.isConstructorParameterList(parameterList) ? this.constructorMax : this.max;
        if (numberOfParameters > maxValue) {
            this.context().newIssue((PHPCheck)this, (Tree)parameterList, String.format(MESSAGE, numberOfParameters, maxValue));
        }
        super.visitParameterList(parameterList);
    }

    private boolean isConstructorParameterList(ParameterListTree parameterList) {
        MethodDeclarationTree constructor;
        if (this.classTree != null && (constructor = this.classTree.fetchConstructor()) != null) {
            return parameterList.equals(constructor.parameters());
        }
        return false;
    }

    public void visitClassDeclaration(ClassDeclarationTree tree) {
        this.classTree = tree;
        super.visitClassDeclaration(tree);
        this.classTree = null;
    }

    public void visitAnonymousClass(AnonymousClassTree tree) {
        this.classTree = tree;
        super.visitAnonymousClass(tree);
        this.classTree = null;
    }
}

