/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S104")
public class TooManyLinesInFileCheck
extends PHPVisitorCheck {
    public static final String KEY = "S104";
    private static final String MESSAGE = "File \"%s\" has %s lines, which is greater than %s authorized. Split it into smaller files.";
    private static final int DEFAULT = 1000;
    @RuleProperty(key="max", defaultValue="1000")
    public int max = 1000;

    public void visitCompilationUnit(CompilationUnitTree tree) {
        int numberOfLines = tree.eofToken().line();
        if (numberOfLines > this.max) {
            this.context().newFileIssue((PHPCheck)this, String.format(MESSAGE, this.context().file().getName(), numberOfLines, this.max));
        }
    }
}

