/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.FunctionTree;
import org.sonar.plugins.php.api.tree.statement.BlockTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;

@Rule(key="S138")
public class TooManyLinesInFunctionCheck
extends PHPSubscriptionCheck {
    public static final String KEY = "S138";
    private static final String MESSAGE = "This function %s has %s lines, which is greater than the %s lines authorized. Split it into smaller functions.";
    private static final int DEFAULT = 150;
    @RuleProperty(key="max", defaultValue="150")
    public int max = 150;

    public List<Tree.Kind> nodesToVisit() {
        return CheckUtils.FUNCTION_KINDS;
    }

    public void visitNode(Tree tree) {
        FunctionTree declaration = (FunctionTree)tree;
        int nbLines = TooManyLinesInFunctionCheck.getNumberOfLines(declaration);
        if (nbLines > this.max) {
            this.context().newIssue((PHPCheck)this, (Tree)declaration.functionToken(), (Tree)declaration.parameters(), String.format(MESSAGE, CheckUtils.getFunctionName(declaration), nbLines, this.max));
        }
    }

    public static int getNumberOfLines(FunctionTree declaration) {
        Tree body = declaration.body();
        if (!body.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            return 0;
        }
        BlockTree block = (BlockTree)body;
        int firstLine = block.openCurlyBraceToken().line();
        int lastLine = block.closeCurlyBraceToken().line();
        return lastLine - firstLine + 1;
    }
}

