/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.php.api.CharsetAwareVisitor;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1131")
public class TrailingWhitespaceCheck
extends PHPVisitorCheck
implements CharsetAwareVisitor {
    public static final String KEY = "S1131";
    private static final String MESSAGE = "Remove the useless trailing whitespaces at the end of this line.";
    private Charset charset;
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]");

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void visitCompilationUnit(CompilationUnitTree tree) {
        List lines;
        try {
            lines = Files.readLines((File)this.context().file(), (Charset)this.charset);
        }
        catch (IOException e) {
            throw new IllegalStateException("Check S1131: Can't read the file", e);
        }
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            if (line.length() <= 0 || !WHITESPACE_PATTERN.matcher(line.subSequence(line.length() - 1, line.length())).matches()) continue;
            this.context().newLineIssue((PHPCheck)this, i + 1, MESSAGE);
        }
    }
}

