/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.tree.symbols.Scope;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.expression.IdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1172")
public class UnusedFunctionParametersCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1172";
    private static final String MESSAGE = "Remove the unused function parameter \"%s\".";
    private Deque<Boolean> mayOverrideStack = new ArrayDeque<Boolean>();

    public void visitClassDeclaration(ClassDeclarationTree tree) {
        this.mayOverrideStack.addLast(UnusedFunctionParametersCheck.mayOverride((ClassTree)tree));
        super.visitClassDeclaration(tree);
        this.mayOverrideStack.removeLast();
    }

    private static boolean mayOverride(ClassTree tree) {
        return tree.superClass() != null || tree.implementsToken() != null;
    }

    public void visitAnonymousClass(AnonymousClassTree tree) {
        this.mayOverrideStack.addLast(UnusedFunctionParametersCheck.mayOverride((ClassTree)tree));
        super.visitAnonymousClass(tree);
        this.mayOverrideStack.removeLast();
    }

    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.checkParameters((FunctionTree)tree);
        super.visitFunctionDeclaration(tree);
    }

    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.checkParameters((FunctionTree)tree);
        super.visitFunctionExpression(tree);
    }

    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        if (!this.isExcluded(tree)) {
            this.checkParameters((FunctionTree)tree);
        }
        super.visitMethodDeclaration(tree);
    }

    private void checkParameters(FunctionTree tree) {
        Scope scope = this.context().symbolTable().getScopeFor((Tree)tree);
        if (scope != null) {
            ArrayList<IdentifierTree> unused = new ArrayList<IdentifierTree>();
            for (Symbol symbol : scope.getSymbols(Symbol.Kind.PARAMETER)) {
                if (!symbol.usages().isEmpty()) continue;
                unused.add(symbol.declaration());
            }
            for (IdentifierTree unusedParameter : unused) {
                this.context().newIssue((PHPCheck)this, (Tree)unusedParameter, String.format(MESSAGE, unusedParameter.text()));
            }
        }
    }

    public boolean isExcluded(MethodDeclarationTree tree) {
        return this.mayOverrideStack.getLast() != false && !CheckUtils.hasModifier(tree.modifiers(), "private") || !tree.body().is(new Tree.Kind[]{Tree.Kind.BLOCK}) || CheckUtils.isOverriding(tree);
    }
}

