/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.tree.symbols.Scope;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.expression.IdentifierTree;
import org.sonar.plugins.php.api.tree.expression.ReferenceVariableTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.tree.expression.VariableTree;
import org.sonar.plugins.php.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.php.api.tree.statement.ForEachStatementTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1481")
public class UnusedLocalVariableCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1481";
    private static final String MESSAGE = "Remove this unused \"%s\" local variable.";
    private List<IdentifierTree> exclusions = new ArrayList<IdentifierTree>();

    public void visitFunctionExpression(FunctionExpressionTree tree) {
        if (tree.lexicalVars() != null) {
            Scope parentScope = this.context().symbolTable().getScopeFor((Tree)tree).outer();
            for (VariableTree variableTree : tree.lexicalVars().variables()) {
                VariableIdentifierTree variableIdentifier;
                Symbol parentScopeSymbol;
                if (!variableTree.is(new Tree.Kind[]{Tree.Kind.VARIABLE_IDENTIFIER}) || (parentScopeSymbol = parentScope.getSymbol((variableIdentifier = (VariableIdentifierTree)variableTree).text(), new Symbol.Kind[0])) != null) continue;
                this.exclusions.add((IdentifierTree)variableIdentifier);
            }
        }
        super.visitFunctionExpression(tree);
    }

    public void visitFunctionCall(FunctionCallTree tree) {
        for (ExpressionTree argument : tree.arguments()) {
            if (!argument.is(new Tree.Kind[]{Tree.Kind.VARIABLE_IDENTIFIER})) continue;
            this.exclusions.add((IdentifierTree)argument);
        }
        super.visitFunctionCall(tree);
    }

    public void visitCatchBlock(CatchBlockTree tree) {
        this.exclusions.add((IdentifierTree)tree.variable());
        super.visitCatchBlock(tree);
    }

    public void visitForEachStatement(ForEachStatementTree tree) {
        if (tree.key() != null) {
            if (tree.value().is(new Tree.Kind[]{Tree.Kind.VARIABLE_IDENTIFIER})) {
                this.exclusions.add((IdentifierTree)tree.value());
            } else if (tree.value().is(new Tree.Kind[]{Tree.Kind.REFERENCE_VARIABLE}) && ((ReferenceVariableTree)tree.value()).variableExpression().is(new Tree.Kind[]{Tree.Kind.VARIABLE_IDENTIFIER})) {
                this.exclusions.add((IdentifierTree)((ReferenceVariableTree)tree.value()).variableExpression());
            }
        }
        super.visitForEachStatement(tree);
    }

    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.exclusions.clear();
        super.visitCompilationUnit(tree);
        for (Scope scope : this.context().symbolTable().getScopes()) {
            if (!CheckUtils.isFunction(scope.tree())) continue;
            this.checkScope(scope);
        }
    }

    private void checkScope(Scope scope) {
        for (Symbol symbol : scope.getSymbols(Symbol.Kind.VARIABLE)) {
            if (!symbol.scope().equals(scope) || !symbol.usages().isEmpty() || this.exclusions.contains(symbol.declaration())) continue;
            this.context().newIssue((PHPCheck)this, (Tree)symbol.declaration(), String.format(MESSAGE, symbol.name()));
        }
    }
}

