/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1068")
public class UnusedPrivateFieldCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1068";
    private static final String MESSAGE = "Remove this unused \"%s\" private field.";

    public void visitCompilationUnit(CompilationUnitTree tree) {
        for (Symbol fieldSymbol : this.context().symbolTable().getSymbols(Symbol.Kind.FIELD)) {
            if (!fieldSymbol.hasModifier("private") || !fieldSymbol.usages().isEmpty()) continue;
            this.context().newIssue((PHPCheck)this, (Tree)fieldSymbol.declaration(), String.format(MESSAGE, fieldSymbol.name()));
        }
    }
}

