/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.tree.symbols.Scope;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.expression.IdentifierTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1144")
public class UnusedPrivateMethodCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1144";
    private static final String MESSAGE = "Remove this unused private \"%s\" method.";
    private List<String> stringLiterals = new ArrayList<String>();

    public void visitClassDeclaration(ClassDeclarationTree tree) {
        this.stringLiterals.clear();
        super.visitClassDeclaration(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS_DECLARATION})) {
            this.checkClass((ClassTree)tree);
        }
    }

    private void checkClass(ClassTree tree) {
        Scope classScope = this.context().symbolTable().getScopeFor((Tree)tree);
        for (Symbol methodSymbol : classScope.getSymbols(Symbol.Kind.FUNCTION)) {
            boolean ruleConditions = methodSymbol.hasModifier("private") && methodSymbol.usages().isEmpty();
            if (!ruleConditions || UnusedPrivateMethodCheck.isConstructor(methodSymbol.declaration(), tree) || UnusedPrivateMethodCheck.isMagicMethod(methodSymbol.name()) || this.isUsedInStringLiteral(methodSymbol)) continue;
            this.context().newIssue((PHPCheck)this, (Tree)methodSymbol.declaration(), String.format(MESSAGE, methodSymbol.name()));
        }
    }

    public void visitAnonymousClass(AnonymousClassTree tree) {
        this.stringLiterals.clear();
        super.visitAnonymousClass(tree);
        this.checkClass((ClassTree)tree);
    }

    public void visitLiteral(LiteralTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.REGULAR_STRING_LITERAL})) {
            String value = tree.value();
            this.stringLiterals.add(value.substring(1, value.length() - 1));
        }
    }

    private boolean isUsedInStringLiteral(Symbol methodSymbol) {
        for (String stringLiteral : this.stringLiterals) {
            if (!stringLiteral.contains(methodSymbol.name())) continue;
            return true;
        }
        return false;
    }

    private static boolean isConstructor(IdentifierTree methodName, ClassTree classDec) {
        MethodDeclarationTree constructor = classDec.fetchConstructor();
        return constructor != null && constructor.name().equals(methodName);
    }

    private static boolean isMagicMethod(String methodName) {
        return methodName.startsWith("__");
    }
}

