/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.php.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1848")
public class UselessObjectCreationCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1848";
    private static final String MESSAGE = "Either remove this useless object instantiation of class \"%s\" or use it";

    public void visitExpressionStatement(ExpressionStatementTree tree) {
        super.visitExpressionStatement(tree);
        if (tree.expression().is(new Tree.Kind[]{Tree.Kind.NEW_EXPRESSION})) {
            NewExpressionTree newExpression = (NewExpressionTree)tree.expression();
            String message = String.format(MESSAGE, UselessObjectCreationCheck.getClassName(newExpression.expression()));
            this.context().newIssue((PHPCheck)this, (Tree)newExpression, message);
        }
    }

    private static String getClassName(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.FUNCTION_CALL})) {
            return ((FunctionCallTree)expression).callee().toString();
        }
        return expression.toString();
    }
}

