/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.formatting;

import javax.annotation.Nullable;
import org.sonar.php.checks.FormattingStandardCheck;
import org.sonar.php.checks.formatting.FormattingCheck;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

public class ExtendsImplementsLineCheck
extends PHPVisitorCheck
implements FormattingCheck {
    private static final String MESSAGE = "Move %s to the same line as the declaration of its class name, \"%s\".";
    private FormattingStandardCheck check;

    @Override
    public void checkFormat(FormattingStandardCheck formattingCheck, ScriptTree scriptTree) {
        this.check = formattingCheck;
        super.visitScript(scriptTree);
    }

    public void visitClassDeclaration(ClassDeclarationTree tree) {
        if (this.check.isExtendsAndImplementsLine && tree.is(new Tree.Kind[]{Tree.Kind.CLASS_DECLARATION})) {
            this.checkExtendsAndImplementsLine(tree);
        }
        super.visitClassDeclaration(tree);
    }

    private void checkExtendsAndImplementsLine(ClassDeclarationTree tree) {
        boolean isImplementsOnClassNameLine;
        SyntaxToken classNameToken = tree.name().token();
        int nameLine = classNameToken.line();
        boolean isExtendsOnClassNameLine = ExtendsImplementsLineCheck.isExtendsOnClassNameLine(tree, nameLine);
        String partialMessage = ExtendsImplementsLineCheck.getIssuePartialMessage(isExtendsOnClassNameLine, isImplementsOnClassNameLine = ExtendsImplementsLineCheck.isImplementsOnClassNameLine(tree, nameLine));
        if (partialMessage != null) {
            this.check.reportIssue(String.format(MESSAGE, partialMessage, classNameToken.text()), new Tree[]{tree.name()});
        }
    }

    private static boolean isExtendsOnClassNameLine(ClassDeclarationTree classDeclaration, int classNameLine) {
        SyntaxToken extendsToken = classDeclaration.extendsToken();
        return extendsToken == null || classNameLine == extendsToken.line();
    }

    private static boolean isImplementsOnClassNameLine(ClassDeclarationTree classDeclaration, int classNameLine) {
        SyntaxToken implementsToken = classDeclaration.implementsToken();
        return implementsToken == null || classNameLine == implementsToken.line();
    }

    @Nullable
    private static String getIssuePartialMessage(boolean isExtendsOnClassNameLine, boolean isImplementsOnClassNameLine) {
        String msg = null;
        if (!isExtendsOnClassNameLine && !isImplementsOnClassNameLine) {
            msg = "\"extends\" and \"implements\" keywords";
        }
        if (!isExtendsOnClassNameLine && isImplementsOnClassNameLine) {
            msg = "\"extends\" keyword";
        }
        if (isExtendsOnClassNameLine && !isImplementsOnClassNameLine) {
            msg = "\"implements\" keyword";
        }
        return msg;
    }
}

