/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.formatting;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.php.checks.FormattingStandardCheck;
import org.sonar.php.checks.formatting.FormattingCheck;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.php.api.tree.statement.NamespaceStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.tree.statement.UseStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class NamespaceAndUseStatementCheck
extends PHPVisitorCheck
implements FormattingCheck {
    private static final String BLANK_LINE_NAMESPACE_MESSAGE = "Add a blank line after this \"namespace%s\" declaration.";
    private static final String BLANK_LINE_USE_MESSAGE = "Add a blank line after this \"use\" declaration.";
    private static final String USE_AFTER_NAMESPACE_MESSAGE = "Move the use declarations after the namespace declarations.";
    private List<UseStatementTree> useStatements = Lists.newArrayList();
    private StatementTree nextStatement = null;
    private FormattingStandardCheck check = null;

    @Override
    public void checkFormat(FormattingStandardCheck formattingCheck, ScriptTree scriptTree) {
        this.check = formattingCheck;
        this.visitScript(scriptTree);
        this.nextStatement = null;
        this.useStatements.clear();
    }

    public void visitScript(ScriptTree tree) {
        List statements = tree.statements();
        int nbStatements = statements.size();
        for (int i = 0; i < nbStatements - 1; ++i) {
            this.nextStatement = (StatementTree)statements.get(i + 1);
            ((StatementTree)statements.get(i)).accept((VisitorCheck)this);
        }
    }

    public void visitNamespaceStatement(NamespaceStatementTree tree) {
        if (this.check.hasNamespaceBlankLine && !this.isFollowedWithBlankLine((Tree)tree)) {
            String message = String.format(BLANK_LINE_NAMESPACE_MESSAGE, tree.namespaceName() == null ? "" : " " + tree.namespaceName().fullName());
            this.reportIssue(message, (Tree)tree.namespaceToken());
        }
    }

    public void visitUseStatement(UseStatementTree tree) {
        this.useStatements.add(tree);
        if (!this.nextStatement.is(new Tree.Kind[]{Tree.Kind.USE_STATEMENT})) {
            this.checkUsesAreBeforeNamespace();
            this.checkBlankLineAfterUses(tree);
            this.useStatements.clear();
        }
    }

    private void checkBlankLineAfterUses(UseStatementTree useStatement) {
        if (this.check.hasUseBlankLine && !this.isFollowedWithBlankLine((Tree)useStatement)) {
            this.reportIssue(BLANK_LINE_USE_MESSAGE, (Tree)((UseStatementTree)Iterables.getLast(this.useStatements)).useToken());
        }
    }

    private void checkUsesAreBeforeNamespace() {
        if (this.check.isUseAfterNamespace && this.nextStatement.is(new Tree.Kind[]{Tree.Kind.NAMESPACE_STATEMENT})) {
            this.reportIssue(USE_AFTER_NAMESPACE_MESSAGE, (Tree)this.useStatements.get(0).useToken());
        }
    }

    private void reportIssue(String message, Tree tree) {
        this.check.reportIssue(message, tree);
    }

    private boolean isFollowedWithBlankLine(Tree tree) {
        int nextLine = ((PHPTree)tree).getLastToken().line() + 1;
        SyntaxToken nextToken = ((PHPTree)this.nextStatement).getFirstToken();
        boolean isFollowedWithBlankLine = true;
        for (SyntaxTrivia trivia : nextToken.trivias()) {
            isFollowedWithBlankLine &= trivia.line() != nextLine;
        }
        return isFollowedWithBlankLine && nextToken.line() != nextLine;
    }
}

