/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.phpini;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.ini.BasePhpIniIssue;
import org.sonar.php.ini.PhpIniCheck;
import org.sonar.php.ini.PhpIniIssue;
import org.sonar.php.ini.tree.Directive;
import org.sonar.php.ini.tree.PhpIniFile;

@Rule(key="S3333")
public class OpenBasedirCheck
implements PhpIniCheck {
    private static final String FILE_MESSAGE = "Set \"open_basedir\".";
    private static final String DIRECTIVE_MESSAGE = "Limit \"open_basedir\" to a narrower path than \"%s\".";

    public List<PhpIniIssue> analyze(PhpIniFile phpIniFile) {
        ArrayList<PhpIniIssue> issues = new ArrayList<PhpIniIssue>();
        List directives = phpIniFile.directivesForName("open_basedir");
        if (directives.isEmpty()) {
            issues.add(BasePhpIniIssue.newIssue((String)FILE_MESSAGE));
        }
        block0: for (Directive directive : directives) {
            String value = directive.value().text();
            if (value.startsWith("\"")) {
                value = value.substring(1);
            }
            if (value.endsWith("\"")) {
                value = value.substring(0, value.length() - 1);
            }
            for (String path : value.split(":|;")) {
                if (!".".equals(path) && !"/".equals(path)) continue;
                String message = String.format(DIRECTIVE_MESSAGE, path);
                int line = directive.name().line();
                issues.add(BasePhpIniIssue.newIssue((String)message).line(line));
                continue block0;
            }
        }
        return issues;
    }
}

