/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.utils;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.statement.BlockTree;
import org.sonar.plugins.php.api.tree.statement.DeclareStatementTree;
import org.sonar.plugins.php.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.php.api.tree.statement.ElseifClauseTree;
import org.sonar.plugins.php.api.tree.statement.ForEachStatementTree;
import org.sonar.plugins.php.api.tree.statement.ForStatementTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.tree.statement.NamespaceStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.tree.statement.SwitchCaseClauseTree;
import org.sonar.plugins.php.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;

public class AbstractStatementsCheck
extends PHPSubscriptionCheck {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.SCRIPT, (Object)Tree.Kind.BLOCK, (Object)Tree.Kind.CASE_CLAUSE, (Object)Tree.Kind.DEFAULT_CLAUSE, (Object)Tree.Kind.DECLARE_STATEMENT, (Object)Tree.Kind.IF_STATEMENT, (Object)Tree.Kind.ALTERNATIVE_IF_STATEMENT, (Object)Tree.Kind.ELSE_CLAUSE, (Object)Tree.Kind.ALTERNATIVE_ELSE_CLAUSE, (Object)Tree.Kind.ELSEIF_CLAUSE, (Object)Tree.Kind.ALTERNATIVE_ELSEIF_CLAUSE, (Object)Tree.Kind.FOREACH_STATEMENT, (Object[])new Tree.Kind[]{Tree.Kind.ALTERNATIVE_FOREACH_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.ALTERNATIVE_FOR_STATEMENT, Tree.Kind.NAMESPACE_STATEMENT, Tree.Kind.WHILE_STATEMENT});
    }

    public static List<StatementTree> getStatements(Tree tree) {
        List statements = Collections.emptyList();
        switch (tree.getKind()) {
            case SCRIPT: {
                statements = ((ScriptTree)tree).statements();
                break;
            }
            case BLOCK: {
                statements = ((BlockTree)tree).statements();
                break;
            }
            case CASE_CLAUSE: 
            case DEFAULT_CLAUSE: {
                statements = ((SwitchCaseClauseTree)tree).statements();
                break;
            }
            case DECLARE_STATEMENT: {
                statements = ((DeclareStatementTree)tree).statements();
                break;
            }
            case IF_STATEMENT: 
            case ALTERNATIVE_IF_STATEMENT: {
                statements = ((IfStatementTree)tree).statements();
                break;
            }
            case ELSE_CLAUSE: 
            case ALTERNATIVE_ELSE_CLAUSE: {
                statements = ((ElseClauseTree)tree).statements();
                break;
            }
            case ELSEIF_CLAUSE: 
            case ALTERNATIVE_ELSEIF_CLAUSE: {
                statements = ((ElseifClauseTree)tree).statements();
                break;
            }
            case FOREACH_STATEMENT: 
            case ALTERNATIVE_FOREACH_STATEMENT: {
                statements = ((ForEachStatementTree)tree).statements();
                break;
            }
            case FOR_STATEMENT: 
            case ALTERNATIVE_FOR_STATEMENT: {
                statements = ((ForStatementTree)tree).statements();
                break;
            }
            case NAMESPACE_STATEMENT: {
                statements = ((NamespaceStatementTree)tree).statements();
                break;
            }
            case WHILE_STATEMENT: {
                statements = ((WhileStatementTree)tree).statements();
                break;
            }
        }
        return statements;
    }
}

