/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.lexical.SyntaxTrivia;

public class CheckUtils {
    private static final Tree.Kind[] FUNCTION_KINDS_ARRAY = new Tree.Kind[]{Tree.Kind.METHOD_DECLARATION, Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.FUNCTION_EXPRESSION};
    public static final ImmutableList<Tree.Kind> FUNCTION_KINDS = ImmutableList.copyOf((Object[])FUNCTION_KINDS_ARRAY);
    public static final ImmutableMap<String, String> PREDEFINED_VARIABLES = ImmutableMap.builder().put((Object)"$HTTP_SERVER_VARS", (Object)"$_SERVER").put((Object)"$HTTP_GET_VARS", (Object)"$_GET").put((Object)"$HTTP_POST_VARS", (Object)"$_POST").put((Object)"$HTTP_POST_FILES", (Object)"$_FILES").put((Object)"$HTTP_SESSION_VARS", (Object)"$_SESSION").put((Object)"$HTTP_ENV_VARS", (Object)"$_ENV").put((Object)"$HTTP_COOKIE_VARS", (Object)"$_COOKIE").build();

    private CheckUtils() {
    }

    public static boolean isFunction(Tree tree) {
        return tree.is(FUNCTION_KINDS_ARRAY);
    }

    public static String getFunctionName(FunctionTree functionDec) {
        if (functionDec.is(new Tree.Kind[]{Tree.Kind.FUNCTION_DECLARATION})) {
            return "\"" + ((FunctionDeclarationTree)functionDec).name().text() + "\"";
        }
        if (functionDec.is(new Tree.Kind[]{Tree.Kind.METHOD_DECLARATION})) {
            return "\"" + ((MethodDeclarationTree)functionDec).name().text() + "\"";
        }
        return "expression";
    }

    public static boolean isOverriding(MethodDeclarationTree declaration) {
        for (SyntaxTrivia comment : ((PHPTree)declaration).getFirstToken().trivias()) {
            if (!StringUtils.containsIgnoreCase((String)comment.text(), (String)"@inheritdoc")) continue;
            return true;
        }
        return false;
    }

    public static boolean isExitExpression(FunctionCallTree functionCallTree) {
        String callee = functionCallTree.callee().toString();
        return "die".equalsIgnoreCase(callee) || "exit".equalsIgnoreCase(callee);
    }

    public static boolean hasModifier(List<SyntaxToken> modifiers, String toFind) {
        for (SyntaxToken modifier : modifiers) {
            if (!modifier.text().equalsIgnoreCase(toFind)) continue;
            return true;
        }
        return false;
    }

    public static boolean isClosingTag(SyntaxToken token) {
        if (token.is(new Tree.Kind[]{Tree.Kind.INLINE_HTML_TOKEN})) {
            String text = token.text().trim();
            return "?>".equals(text) || "%>".equals(text);
        }
        return false;
    }
}

