/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.utils;

import com.google.common.collect.ImmutableSet;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

public abstract class FunctionUsageCheck
extends PHPVisitorCheck {
    protected abstract ImmutableSet<String> functionNames();

    protected abstract void createIssue(FunctionCallTree var1);

    public void visitFunctionCall(FunctionCallTree tree) {
        if (this.isForbiddenFunction(tree.callee())) {
            this.createIssue(tree);
        }
        super.visitFunctionCall(tree);
    }

    private boolean isForbiddenFunction(ExpressionTree callee) {
        return callee.is(new Tree.Kind[]{Tree.Kind.NAMESPACE_NAME}) && this.functionNames().contains((Object)((NamespaceNameTree)callee).qualifiedName());
    }
}

