/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.utils;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

public class TokenVisitor
extends PHPVisitorCheck {
    List<SyntaxToken> tokens = new ArrayList<SyntaxToken>();

    public TokenVisitor(Tree tree) {
        this.scan(tree);
    }

    public static List<SyntaxToken> tokens(Tree tree) {
        TokenVisitor visitor = new TokenVisitor(tree);
        return visitor.getTokens();
    }

    private List<SyntaxToken> getTokens() {
        return this.tokens;
    }

    public void visitToken(SyntaxToken token) {
        super.visitToken(token);
        if (token.is(new Tree.Kind[]{Tree.Kind.TOKEN})) {
            this.tokens.add(token);
        }
    }

    @Nullable
    public SyntaxToken tokenByValue(String ... tokenValues) {
        for (SyntaxToken token : this.tokens) {
            if (!ArrayUtils.contains((Object[])tokenValues, (Object)token.text())) continue;
            return token;
        }
        return null;
    }

    public SyntaxToken prevToken(SyntaxToken token) {
        for (int i = 0; i < this.tokens.size(); ++i) {
            if (!token.equals(this.tokens.get(i))) continue;
            if (i <= 0) break;
            return this.tokens.get(i - 1);
        }
        return null;
    }

    public SyntaxToken nextToken(SyntaxToken token) {
        for (int i = 0; i < this.tokens.size(); ++i) {
            if (!token.equals(this.tokens.get(i))) continue;
            if (i >= this.tokens.size() - 1) break;
            return this.tokens.get(i + 1);
        }
        return null;
    }
}

