/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.rule.RuleKey;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPCustomRulesDefinition;

public class PHPChecks {
    private final CheckFactory checkFactory;
    private Set<Checks<PHPCheck>> checksByRepository = Sets.newHashSet();

    private PHPChecks(CheckFactory checkFactory) {
        this.checkFactory = checkFactory;
    }

    public static PHPChecks createPHPCheck(CheckFactory checkFactory) {
        return new PHPChecks(checkFactory);
    }

    public PHPChecks addChecks(String repositoryKey, Iterable<Class> checkClass) {
        this.checksByRepository.add((Checks<PHPCheck>)this.checkFactory.create(repositoryKey).addAnnotatedChecks(checkClass));
        return this;
    }

    public PHPChecks addCustomChecks(@Nullable PHPCustomRulesDefinition[] customRulesDefinitions) {
        if (customRulesDefinitions != null) {
            for (PHPCustomRulesDefinition rulesDefinition : customRulesDefinitions) {
                this.addChecks(rulesDefinition.repositoryKey(), Lists.newArrayList((Iterable)rulesDefinition.checkClasses()));
            }
        }
        return this;
    }

    public List<PHPCheck> all() {
        ArrayList allVisitors = Lists.newArrayList();
        for (Checks<PHPCheck> checks : this.checksByRepository) {
            allVisitors.addAll(checks.all());
        }
        return allVisitors;
    }

    @Nullable
    public RuleKey ruleKeyFor(PHPCheck check) {
        for (Checks<PHPCheck> checks : this.checksByRepository) {
            RuleKey ruleKey = checks.ruleKey((Object)check);
            if (ruleKey == null) continue;
            return ruleKey;
        }
        return null;
    }
}

