/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Set;
import org.sonar.api.profiles.ProfileDefinition;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.utils.ValidationMessages;

public final class PHPProfile
extends ProfileDefinition {
    private final RuleFinder ruleFinder;

    public PHPProfile(RuleFinder ruleFinder) {
        this.ruleFinder = ruleFinder;
    }

    public RulesProfile createProfile(ValidationMessages validation) {
        RulesProfile profile = RulesProfile.create((String)"Sonar way", (String)"php");
        this.loadFromCommonRepository(profile);
        this.loadFromJsonProfile(profile);
        return profile;
    }

    private void loadFromCommonRepository(RulesProfile profile) {
        Rule duplicatedBlocksRule = this.ruleFinder.findByKey("common-php", "DuplicatedBlocks");
        if (duplicatedBlocksRule != null) {
            profile.activateRule(duplicatedBlocksRule, null);
        }
    }

    private void loadFromJsonProfile(RulesProfile profile) {
        URL profileUrl = ((Object)((Object)this)).getClass().getResource("/org/sonar/l10n/php/rules/php/Sonar_way_profile.json");
        try {
            Gson gson = new Gson();
            Profile jsonProfile = (Profile)gson.fromJson(Resources.toString((URL)profileUrl, (Charset)Charsets.UTF_8), Profile.class);
            for (String ruleKey : jsonProfile.ruleKeys) {
                Rule rule = this.ruleFinder.findByKey("php", ruleKey);
                profile.activateRule(rule, null);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read: " + profileUrl, e);
        }
    }

    private static class Profile {
        Set<String> ruleKeys;

        private Profile() {
        }
    }
}

