/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.batch.sensor.symbol.NewSymbolTable;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.rule.RuleKey;
import org.sonar.php.PHPAnalyzer;
import org.sonar.php.checks.CheckList;
import org.sonar.php.checks.ParsingErrorCheck;
import org.sonar.php.metrics.CpdVisitor;
import org.sonar.php.metrics.FileMeasures;
import org.sonar.php.tree.visitors.LegacyIssue;
import org.sonar.plugins.php.PHPChecks;
import org.sonar.plugins.php.PhpPlugin;
import org.sonar.plugins.php.api.visitors.FileIssue;
import org.sonar.plugins.php.api.visitors.IssueLocation;
import org.sonar.plugins.php.api.visitors.LineIssue;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPCustomRulesDefinition;
import org.sonar.plugins.php.api.visitors.PhpIssue;
import org.sonar.plugins.php.api.visitors.PreciseIssue;
import org.sonar.plugins.php.phpunit.PhpUnitCoverageResultParser;
import org.sonar.plugins.php.phpunit.PhpUnitItCoverageResultParser;
import org.sonar.plugins.php.phpunit.PhpUnitOverallCoverageResultParser;
import org.sonar.plugins.php.phpunit.PhpUnitResultParser;
import org.sonar.plugins.php.phpunit.PhpUnitService;
import org.sonar.squidbridge.ProgressReport;
import org.sonar.squidbridge.api.AnalysisException;

public class PHPSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(PHPSensor.class);
    private final FileLinesContextFactory fileLinesContextFactory;
    private final PHPChecks checks;
    private final NoSonarFilter noSonarFilter;
    private RuleKey parsingErrorRuleKey;
    private FileSystem fileSystem;

    public PHPSensor(FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter) {
        this(fileLinesContextFactory, checkFactory, noSonarFilter, null);
    }

    public PHPSensor(FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, @Nullable PHPCustomRulesDefinition[] customRulesDefinitions) {
        this.checks = PHPChecks.createPHPCheck(checkFactory).addChecks("php", CheckList.getChecks()).addCustomChecks(customRulesDefinitions);
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
        this.parsingErrorRuleKey = this.getParsingErrorRuleKey();
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("php").name("PHP sensor").onlyOnFileType(InputFile.Type.MAIN);
    }

    public void execute(SensorContext context) {
        this.fileSystem = context.fileSystem();
        FilePredicate mainFilePredicate = this.fileSystem.predicates().and(this.fileSystem.predicates().hasType(InputFile.Type.MAIN), this.fileSystem.predicates().hasLanguage("php"));
        ImmutableList<PHPCheck> visitors = this.getVisitors((PHPCheck)new CpdVisitor(context));
        PHPAnalyzer phpAnalyzer = new PHPAnalyzer(this.fileSystem.encoding(), visitors);
        ArrayList inputFiles = Lists.newArrayList((Iterable)this.fileSystem.inputFiles(mainFilePredicate));
        ProgressReport progressReport = new ProgressReport("Report about progress of PHP analyzer", TimeUnit.SECONDS.toMillis(10L));
        progressReport.start((Collection)Lists.newArrayList((Iterable)this.fileSystem.files(mainFilePredicate)));
        HashMap<File, Integer> numberOLinesOfCode = new HashMap<File, Integer>();
        this.analyseFiles(context, phpAnalyzer, inputFiles, progressReport, numberOLinesOfCode);
        this.processCoverage(context, numberOLinesOfCode);
    }

    private void processCoverage(SensorContext context, Map<File, Integer> numberOfLinesOfCode) {
        PhpUnitService phpUnitSensor = new PhpUnitService(this.fileSystem, new PhpUnitResultParser(this.fileSystem), new PhpUnitCoverageResultParser(this.fileSystem), new PhpUnitItCoverageResultParser(this.fileSystem), new PhpUnitOverallCoverageResultParser(this.fileSystem));
        phpUnitSensor.execute(context, numberOfLinesOfCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void analyseFiles(SensorContext context, PHPAnalyzer phpAnalyzer, List<InputFile> inputFiles, ProgressReport progressReport, Map<File, Integer> numberOfLinesOfCode) {
        boolean success = false;
        try {
            for (InputFile inputFile : inputFiles) {
                progressReport.nextFile();
                this.analyseFile(context, phpAnalyzer, inputFile, numberOfLinesOfCode);
            }
            success = true;
        }
        finally {
            PHPSensor.stopProgressReport(progressReport, success);
        }
    }

    private static void stopProgressReport(ProgressReport progressReport, boolean success) {
        if (success) {
            progressReport.stop();
        } else {
            progressReport.cancel();
        }
    }

    private void analyseFile(SensorContext context, PHPAnalyzer phpAnalyzer, InputFile inputFile, Map<File, Integer> numberOfLinesOfCode) {
        try {
            phpAnalyzer.nextFile(inputFile.file());
            this.saveIssues(context, phpAnalyzer.analyze(), inputFile);
            PHPSensor.saveSyntaxHighlighting(phpAnalyzer.getSyntaxHighlighting(context, inputFile));
            PHPSensor.saveSymbolHighlighting(phpAnalyzer.getSymbolHighlighting(context, inputFile));
            this.saveNewFileMeasures(context, phpAnalyzer.computeMeasures(this.fileLinesContextFactory.createFor(inputFile), numberOfLinesOfCode, context.getSonarQubeVersion().isGreaterThanOrEqual(PhpPlugin.SQ_VERSION_6_2)), inputFile);
        }
        catch (RecognitionException e) {
            PHPSensor.checkInterrupted((Exception)((Object)e));
            LOG.error("Unable to parse file: " + inputFile.absolutePath());
            LOG.error(e.getMessage());
            this.saveParsingIssue(context, e, inputFile);
            return;
        }
        catch (Exception e) {
            PHPSensor.checkInterrupted(e);
            throw new AnalysisException("Could not analyse " + inputFile.absolutePath(), (Throwable)e);
        }
    }

    private static void checkInterrupted(Exception e) {
        Throwable cause = Throwables.getRootCause((Throwable)e);
        if (cause instanceof InterruptedException || cause instanceof InterruptedIOException) {
            throw new AnalysisException("Analysis cancelled", (Throwable)e);
        }
    }

    private static void saveSyntaxHighlighting(NewHighlighting highlighting) {
        highlighting.save();
    }

    private static void saveSymbolHighlighting(NewSymbolTable newSymbolTable) {
        newSymbolTable.save();
    }

    private void saveNewFileMeasures(SensorContext context, FileMeasures fileMeasures, InputFile inputFile) {
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMeasures.getLinesNumber())).forMetric((Metric)CoreMetrics.LINES).save();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMeasures.getLinesOfCodeNumber())).forMetric((Metric)CoreMetrics.NCLOC).save();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMeasures.getCommentLinesNumber())).forMetric((Metric)CoreMetrics.COMMENT_LINES).save();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMeasures.getClassNumber())).forMetric((Metric)CoreMetrics.CLASSES).save();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMeasures.getFunctionNumber())).forMetric((Metric)CoreMetrics.FUNCTIONS).save();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMeasures.getStatementNumber())).forMetric((Metric)CoreMetrics.STATEMENTS).save();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMeasures.getFileComplexity())).forMetric((Metric)CoreMetrics.COMPLEXITY).save();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMeasures.getClassComplexity())).forMetric((Metric)CoreMetrics.COMPLEXITY_IN_CLASSES).save();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMeasures.getFunctionComplexity())).forMetric((Metric)CoreMetrics.COMPLEXITY_IN_FUNCTIONS).save();
        String functionComplexityMeasure = fileMeasures.getFunctionComplexityDistribution().build();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)((Object)functionComplexityMeasure)).forMetric((Metric)CoreMetrics.FUNCTION_COMPLEXITY_DISTRIBUTION).save();
        String fileComplexityMeasure = fileMeasures.getFileComplexityDistribution().build();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)((Object)fileComplexityMeasure)).forMetric((Metric)CoreMetrics.FILE_COMPLEXITY_DISTRIBUTION).save();
        this.noSonarFilter.noSonarInFile(inputFile, fileMeasures.getNoSonarLines());
    }

    private void saveParsingIssue(SensorContext context, RecognitionException e, InputFile inputFile) {
        if (this.parsingErrorRuleKey != null) {
            NewIssue issue = context.newIssue();
            NewIssueLocation location = issue.newLocation().message(e.getMessage()).on((InputComponent)inputFile).at(inputFile.selectLine(e.getLine()));
            issue.forRule(this.parsingErrorRuleKey).at(location).save();
        }
    }

    private void saveIssues(SensorContext context, List<PhpIssue> issues, InputFile inputFile) {
        for (PhpIssue issue : issues) {
            NewIssueLocation location;
            RuleKey ruleKey = this.checks.ruleKeyFor(issue.check());
            NewIssue newIssue = context.newIssue().forRule(ruleKey).gap(issue.cost());
            if (issue instanceof LegacyIssue) {
                LegacyIssue legacyIssue = (LegacyIssue)issue;
                location = newIssue.newLocation().message(legacyIssue.message()).on((InputComponent)inputFile);
                if (legacyIssue.line() > 0) {
                    location.at(inputFile.selectLine(legacyIssue.line()));
                }
                newIssue.at(location);
            } else if (issue instanceof LineIssue) {
                LineIssue lineIssue = (LineIssue)issue;
                location = newIssue.newLocation().message(lineIssue.message()).on((InputComponent)inputFile).at(inputFile.selectLine(lineIssue.line()));
                newIssue.at(location);
            } else if (issue instanceof FileIssue) {
                FileIssue fileIssue = (FileIssue)issue;
                location = newIssue.newLocation().message(fileIssue.message()).on((InputComponent)inputFile);
                newIssue.at(location);
            } else {
                PreciseIssue preciseIssue = (PreciseIssue)issue;
                newIssue.at(PHPSensor.newLocation(inputFile, newIssue, preciseIssue.primaryLocation()));
                preciseIssue.secondaryLocations().forEach(secondary -> newIssue.addLocation(PHPSensor.newLocation(inputFile, newIssue, secondary)));
            }
            newIssue.save();
        }
    }

    private static NewIssueLocation newLocation(InputFile inputFile, NewIssue issue, IssueLocation location) {
        TextRange range = inputFile.newRange(location.startLine(), location.startLineOffset(), location.endLine(), location.endLineOffset());
        NewIssueLocation newLocation = issue.newLocation().on((InputComponent)inputFile).at(range);
        if (location.message() != null) {
            newLocation.message(location.message());
        }
        return newLocation;
    }

    private ImmutableList<PHPCheck> getVisitors(PHPCheck additionalCheck) {
        return ImmutableList.builder().addAll(this.checks.all()).add((Object)additionalCheck).build();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private RuleKey getParsingErrorRuleKey() {
        List keys = this.checks.all().stream().filter(check -> check instanceof ParsingErrorCheck).map(this.checks::ruleKeyFor).collect(Collectors.toList());
        return keys.isEmpty() ? null : (RuleKey)keys.get(0);
    }
}

