/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.php.api.PHPKeyword;
import org.sonar.squidbridge.recognizer.CamelCaseDetector;
import org.sonar.squidbridge.recognizer.CodeRecognizer;
import org.sonar.squidbridge.recognizer.ContainsDetector;
import org.sonar.squidbridge.recognizer.Detector;
import org.sonar.squidbridge.recognizer.EndWithDetector;
import org.sonar.squidbridge.recognizer.KeywordsDetector;
import org.sonar.squidbridge.recognizer.LanguageFootprint;
import org.sonar.squidbridge.text.Source;

@Phase(name=Phase.Name.PRE)
public class NoSonarSensor
implements Sensor {
    private static final double CODE_RECOGNIZER_SENSITIVITY = 0.9;
    private static final Logger LOG = LoggerFactory.getLogger(NoSonarSensor.class);
    private static final String NAME = "NoSonar Sensor";
    private final NoSonarFilter filter;
    private final FileSystem filesystem;
    private final FilePredicates filePredicates;

    public NoSonarSensor(FileSystem filesystem, NoSonarFilter noSonarFilter) {
        this.filter = noSonarFilter;
        this.filesystem = filesystem;
        this.filePredicates = filesystem.predicates();
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name(NAME);
    }

    public void execute(SensorContext context) {
        Iterable sourceFiles = this.filesystem.inputFiles(this.filePredicates.and(this.filePredicates.hasLanguage("php"), this.filePredicates.hasType(InputFile.Type.MAIN)));
        for (InputFile file : sourceFiles) {
            Source source = NoSonarSensor.analyseSourceCode(file.file(), this.filesystem.encoding());
            if (source == null) continue;
            this.filter.noSonarInFile(file, source.getNoSonarTagLines());
        }
    }

    protected static Source analyseSourceCode(File file, Charset charset) {
        Source result = null;
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), charset);){
            result = new Source((Reader)reader, new CodeRecognizer(0.9, (LanguageFootprint)new PhpLanguageFootprint()), new String[0]);
        }
        catch (FileNotFoundException e) {
            LOG.error("Error while parsing file '" + file.getAbsolutePath() + "'", (Throwable)e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to open file '" + file.getAbsolutePath() + "'", e);
        }
        catch (RuntimeException rEx) {
            LOG.error("Error while parsing file '" + file.getAbsolutePath() + "'", (Throwable)rEx);
        }
        return result;
    }

    private static class PhpLanguageFootprint
    implements LanguageFootprint {
        private static final double CAMEL_CASE_PROBABILITY = 0.5;
        private static final double CONDITIONAL_PROBABILITY = 0.95;
        private static final double PHP_KEYWORDS_PROBABILITY = 0.3;
        private static final double BOOLEAN_OPERATOR_PROBABILITY = 0.7;
        private static final double END_WITH_DETECTOR_PROBABILITY = 0.95;
        private final Set<Detector> detectors = new HashSet<Detector>();

        public PhpLanguageFootprint() {
            this.detectors.add((Detector)new EndWithDetector(0.95, new char[]{'}', ';', '{'}));
            this.detectors.add((Detector)new KeywordsDetector(0.7, new String[]{"||", "&&"}));
            this.detectors.add((Detector)new KeywordsDetector(0.3, PHPKeyword.getKeywordValues()));
            this.detectors.add((Detector)new ContainsDetector(0.95, new String[]{"++", "for(", "if(", "while(", "catch(", "switch(", "try{", "else{"}));
            this.detectors.add((Detector)new CamelCaseDetector(0.5));
        }

        public Set<Detector> getDetectors() {
            return this.detectors;
        }
    }
}

