/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.phpunit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.plugins.php.phpunit.PhpUnitTestReport;
import org.sonar.plugins.php.phpunit.xml.TestCase;
import org.sonar.plugins.php.phpunit.xml.TestSuite;

public class PhpTestSuiteReader {
    private static final String TESTSUITE_CLASS_NAME_SEPARATOR = "::";
    private Map<String, PhpUnitTestReport> reportsPerClass = new HashMap<String, PhpUnitTestReport>();

    private static void cumulateTestCaseDetails(TestCase testCase, PhpUnitTestReport report) {
        if ("skipped".equals(testCase.getStatus())) {
            report.setSkipped(report.getSkipped() + 1);
        } else if ("failure".equals(testCase.getStatus())) {
            report.setFailures(report.getFailures() + 1);
        } else if ("error".equals(testCase.getStatus())) {
            report.setErrors(report.getErrors() + 1);
        }
        report.setTests(report.getTests() + 1);
        report.getDetails().add(testCase);
    }

    public void readSuite(TestSuite testSuite, @Nullable String parentFileName) {
        List<TestCase> testCases;
        List<TestSuite> testSuites = testSuite.getTestSuites();
        if (testSuites != null) {
            for (TestSuite childSuite : testSuites) {
                this.readSuite(childSuite, testSuite.getFile());
            }
        }
        if ((testCases = testSuite.getTestCases()) != null) {
            this.readTestCases(testSuite, parentFileName, testCases);
        }
    }

    private void readTestCases(TestSuite testSuite, @Nullable String parentFileName, List<TestCase> testCases) {
        for (TestCase testCase : testCases) {
            PhpUnitTestReport report;
            String testClassName = testCase.getClassName();
            if (testClassName == null) {
                testClassName = StringUtils.substringBefore((String)testSuite.getName(), (String)TESTSUITE_CLASS_NAME_SEPARATOR);
            }
            if ((report = this.reportsPerClass.get(testClassName)) == null) {
                report = new PhpUnitTestReport();
                report.setDetails(new ArrayList<TestCase>());
                report.setClassKey(testClassName);
                String file = testCase.getFile();
                if (file == null) {
                    file = parentFileName;
                }
                if (file != null) {
                    report.setFile(file);
                    this.reportsPerClass.put(testClassName, report);
                }
            }
            if (parentFileName == null) {
                report.setTime(testSuite.getTime());
            }
            PhpTestSuiteReader.cumulateTestCaseDetails(testCase, report);
        }
    }

    public Collection<PhpUnitTestReport> getReportsPerClass() {
        return this.reportsPerClass.values();
    }
}

