/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.phpunit;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.ExtensionPoint;
import org.sonar.api.batch.BatchSide;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.coverage.CoverageType;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.plugins.php.PhpPlugin;
import org.sonar.plugins.php.phpunit.PhpUnitParser;
import org.sonar.plugins.php.phpunit.xml.CoverageNode;
import org.sonar.plugins.php.phpunit.xml.FileNode;
import org.sonar.plugins.php.phpunit.xml.LineNode;
import org.sonar.plugins.php.phpunit.xml.MetricsNode;
import org.sonar.plugins.php.phpunit.xml.PackageNode;
import org.sonar.plugins.php.phpunit.xml.ProjectNode;

@BatchSide
@ExtensionPoint
public class PhpUnitCoverageResultParser
implements PhpUnitParser {
    private static final Logger LOG = LoggerFactory.getLogger(PhpUnitCoverageResultParser.class);
    private final FileSystem fileSystem;
    protected Metric<Integer> linesToCoverMetric = CoreMetrics.LINES_TO_COVER;
    protected Metric<Integer> uncoveredLinesMetric = CoreMetrics.UNCOVERED_LINES;
    protected CoverageType coverageType = CoverageType.UNIT;
    private static final String WRONG_LINE_EXCEPTION_MESSAGE = "Line with number %s doesn't belong to file %s";

    public PhpUnitCoverageResultParser(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Override
    public void parse(File coverageReportFile, SensorContext context, Map<File, Integer> numberOfLinesOfCode) {
        LOG.debug("Parsing file: " + coverageReportFile.getAbsolutePath());
        this.parseFile(coverageReportFile, context, numberOfLinesOfCode);
    }

    private void parseFile(File coverageReportFile, SensorContext context, Map<File, Integer> numberOfLinesOfCode) {
        CoverageNode coverage = this.getCoverage(coverageReportFile);
        ArrayList<String> unresolvedPaths = new ArrayList<String>();
        ArrayList<String> resolvedPaths = new ArrayList<String>();
        List<ProjectNode> projects = coverage.getProjects();
        if (projects != null && !projects.isEmpty()) {
            ProjectNode projectNode = projects.get(0);
            this.parseFileNodes(projectNode.getFiles(), unresolvedPaths, resolvedPaths, context);
            this.parsePackagesNodes(projectNode.getPackages(), unresolvedPaths, resolvedPaths, context);
            if (!context.getSonarQubeVersion().isGreaterThanOrEqual(PhpPlugin.SQ_VERSION_6_2)) {
                this.saveMeasureForMissingFiles(resolvedPaths, context, numberOfLinesOfCode);
            }
        }
        if (!unresolvedPaths.isEmpty()) {
            LOG.warn(String.format("Could not resolve %d file paths in %s, first unresolved path: %s", unresolvedPaths.size(), coverageReportFile.getName(), unresolvedPaths.get(0)));
        }
    }

    private void saveMeasureForMissingFiles(List<String> resolvedPaths, SensorContext context, Map<File, Integer> numberOfLinesOfCode) {
        FilePredicate mainFilesPredicate = this.fileSystem.predicates().and(this.fileSystem.predicates().hasType(InputFile.Type.MAIN), this.fileSystem.predicates().hasLanguage("php"));
        for (InputFile phpFile : this.fileSystem.inputFiles(mainFilesPredicate)) {
            if (resolvedPaths.contains(phpFile.relativePath())) continue;
            LOG.debug("Coverage metrics have not been set on '{}': default values will be inserted.", (Object)phpFile.file().getName());
            File file = phpFile.file();
            Integer ncloc = numberOfLinesOfCode.get(file);
            if (ncloc == null) continue;
            context.newMeasure().on((InputComponent)phpFile).withValue((Serializable)ncloc).forMetric(this.linesToCoverMetric).save();
            context.newMeasure().on((InputComponent)phpFile).withValue((Serializable)ncloc).forMetric(this.uncoveredLinesMetric).save();
        }
    }

    private void parsePackagesNodes(@Nullable List<PackageNode> packages, List<String> unresolvedPaths, List<String> resolvedPaths, SensorContext context) {
        if (packages != null) {
            for (PackageNode packageNode : packages) {
                this.parseFileNodes(packageNode.getFiles(), unresolvedPaths, resolvedPaths, context);
            }
        }
    }

    private void parseFileNodes(@Nullable List<FileNode> fileNodes, List<String> unresolvedPaths, List<String> resolvedPaths, SensorContext context) {
        if (fileNodes != null) {
            for (FileNode file : fileNodes) {
                this.saveCoverageMeasure(file, unresolvedPaths, resolvedPaths, context);
            }
        }
    }

    protected void saveCoverageMeasure(FileNode fileNode, List<String> unresolvedPaths, List<String> resolvedPaths, SensorContext context) {
        String path = fileNode.getName();
        InputFile inputFile = this.fileSystem.inputFile(this.fileSystem.predicates().hasAbsolutePath(path));
        if (inputFile != null) {
            resolvedPaths.add(inputFile.relativePath());
            this.saveCoverageLineHitsData(fileNode, inputFile, context);
        } else {
            unresolvedPaths.add(path);
        }
    }

    private void saveCoverageLineHitsData(FileNode fileNode, InputFile inputFile, SensorContext context) {
        NewCoverage newCoverage = context.newCoverage().onFile(inputFile).ofType(this.coverageType);
        if (fileNode.getLines() != null) {
            for (LineNode line : fileNode.getLines()) {
                int lineNum = line.getNum();
                if (lineNum > 0 && lineNum <= inputFile.lines()) {
                    newCoverage.lineHits(line.getNum(), line.getCount());
                    continue;
                }
                LOG.warn(String.format(WRONG_LINE_EXCEPTION_MESSAGE, lineNum, inputFile.file()));
            }
        }
        newCoverage.save();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoverageNode getCoverage(File coverageReportFile) {
        try (FileInputStream inputStream = new FileInputStream(coverageReportFile);){
            XStream xstream = new XStream();
            xstream.setClassLoader(this.getClass().getClassLoader());
            xstream.aliasSystemAttribute("classType", "class");
            xstream.processAnnotations(CoverageNode.class);
            xstream.processAnnotations(ProjectNode.class);
            xstream.processAnnotations(FileNode.class);
            xstream.processAnnotations(MetricsNode.class);
            xstream.processAnnotations(LineNode.class);
            CoverageNode coverageNode = (CoverageNode)xstream.fromXML((InputStream)inputStream);
            return coverageNode;
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't read phpUnit report: " + coverageReportFile.getName(), e);
        }
    }

    public String toString() {
        return "PHPUnit Unit Test Coverage Result Parser";
    }
}

