/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.phpunit;

import com.thoughtworks.xstream.XStreamException;
import java.io.File;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.plugins.php.phpunit.PhpUnitCoverageResultParser;
import org.sonar.plugins.php.phpunit.PhpUnitItCoverageResultParser;
import org.sonar.plugins.php.phpunit.PhpUnitOverallCoverageResultParser;
import org.sonar.plugins.php.phpunit.PhpUnitParser;
import org.sonar.plugins.php.phpunit.PhpUnitResultParser;

public class PhpUnitService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhpUnitService.class);
    private final PhpUnitOverallCoverageResultParser overallCoverageParser;
    private final PhpUnitItCoverageResultParser itCoverageParser;
    private final PhpUnitCoverageResultParser coverageParser;
    private final PhpUnitResultParser parser;
    private final FileSystem fileSystem;

    public PhpUnitService(FileSystem fileSystem, PhpUnitResultParser parser, PhpUnitCoverageResultParser coverageParser, PhpUnitItCoverageResultParser itCoverageParser, PhpUnitOverallCoverageResultParser overallCoverageParser) {
        this.fileSystem = fileSystem;
        this.parser = parser;
        this.coverageParser = coverageParser;
        this.itCoverageParser = itCoverageParser;
        this.overallCoverageParser = overallCoverageParser;
    }

    public void execute(SensorContext context, Map<File, Integer> numberOfLinesOfCode) {
        this.parseReport("sonar.php.tests.reportPath", this.parser, "test", context, numberOfLinesOfCode);
        this.parseReport("sonar.php.coverage.reportPath", this.coverageParser, "unit test coverage", context, numberOfLinesOfCode);
        this.parseReport("sonar.php.coverage.itReportPath", this.itCoverageParser, "integration test coverage", context, numberOfLinesOfCode);
        this.parseReport("sonar.php.coverage.overallReportPath", this.overallCoverageParser, "overall coverage", context, numberOfLinesOfCode);
    }

    private void parseReport(String reportPathKey, PhpUnitParser parser, String msg, SensorContext context, Map<File, Integer> numberOfLinesOfCode) {
        String reportPath = context.settings().getString(reportPathKey);
        if (reportPath != null) {
            File xmlFile = this.getIOFile(reportPath);
            if (xmlFile.exists()) {
                LOGGER.info("Analyzing PHPUnit " + msg + " report: " + reportPath + " with " + parser.toString());
                try {
                    parser.parse(xmlFile, context, numberOfLinesOfCode);
                }
                catch (XStreamException e) {
                    throw new IllegalStateException("Report file is invalid, plugin will stop.", e);
                }
            } else {
                LOGGER.info("PHPUnit xml " + msg + " report not found: " + reportPath);
            }
        } else {
            LOGGER.info("No PHPUnit " + msg + " report provided (see '" + reportPathKey + "' property)");
        }
    }

    private File getIOFile(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(this.fileSystem.baseDir(), path);
        }
        return file;
    }
}

