/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.phpunit.xml;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.apache.commons.lang.StringUtils;

@XStreamAlias(value="testcase")
public final class TestCase {
    public static final String STATUS_ERROR = "error";
    public static final String STATUS_FAILURE = "failure";
    public static final String STATUS_OK = "ok";
    public static final String STATUS_SKIPPED = "skipped";
    @XStreamAsAttribute
    private int assertions;
    @XStreamAsAttribute
    @XStreamAlias(value="class")
    private String className;
    @XStreamAsAttribute
    private String errorMessage;
    @XStreamAsAttribute
    private String file;
    @XStreamAsAttribute
    private int line;
    @XStreamAsAttribute
    private String name;
    @XStreamOmitField
    private String status;
    @XStreamAsAttribute
    private double time;
    @XStreamAlias(value="error")
    private String error;
    @XStreamAlias(value="failure")
    private String failure;

    public int getAssertions() {
        return this.assertions;
    }

    public String getClassName() {
        return this.className;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public String getName() {
        return this.name;
    }

    public String getStackTrace() {
        if (STATUS_ERROR.equals(this.getStatus())) {
            return this.error;
        }
        if (STATUS_FAILURE.equals(this.getStatus())) {
            return this.failure;
        }
        return null;
    }

    public String getStatus() {
        if (StringUtils.isBlank((String)this.status)) {
            this.status = STATUS_OK;
        }
        if (StringUtils.isNotBlank((String)this.error)) {
            this.status = STATUS_ERROR;
        }
        if (StringUtils.isNotBlank((String)this.failure)) {
            this.status = STATUS_FAILURE;
        }
        return this.status;
    }

    public double getTime() {
        return this.time;
    }

    public void setAssertions(int assertions) {
        this.assertions = assertions;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TestCase [assertions=").append(this.assertions).append(", fileName=").append(this.className).append(", errorMessage=").append(this.errorMessage).append(", file=").append(this.file).append(", line=").append(this.line).append(", name=").append(this.name).append(", status=").append(this.status).append(", time=").append(this.time).append(", error=").append(this.error).append(", failure=").append(this.failure).append("]");
        return builder.toString();
    }
}

