/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.user;

import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.internal.google.common.base.Strings;
import org.sonar.api.security.DefaultGroups;

public class UserGroupValidation {
    public static final int GROUP_NAME_MAX_LENGTH = 255;

    private UserGroupValidation() {
    }

    public static void validateGroupName(String groupName) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(groupName) && groupName.trim().length() > 0, "Group name cannot be empty");
        Preconditions.checkArgument(groupName.length() <= 255, "Group name cannot be longer than %s characters", 255);
        Preconditions.checkArgument(!DefaultGroups.isAnyone(groupName), "Anyone group cannot be used");
    }
}

