/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.api.internal.apachecommons.lang.StringUtils;

public class WildcardPattern {
    private static final Map<String, WildcardPattern> CACHE = new HashMap<String, WildcardPattern>();
    private static final String SPECIAL_CHARS = "()[]^$.{}+|";
    private Pattern pattern;
    private String stringRepresentation;

    protected WildcardPattern(String pattern, String directorySeparator) {
        this.stringRepresentation = pattern;
        this.pattern = Pattern.compile(WildcardPattern.toRegexp(pattern, directorySeparator));
    }

    private static String toRegexp(String antPattern, String directorySeparator) {
        int i;
        String escapedDirectorySeparator = '\\' + directorySeparator;
        StringBuilder sb = new StringBuilder(antPattern.length());
        sb.append('^');
        int n = i = antPattern.startsWith("/") || antPattern.startsWith("\\") ? 1 : 0;
        while (i < antPattern.length()) {
            char ch = antPattern.charAt(i);
            if (SPECIAL_CHARS.indexOf(ch) != -1) {
                sb.append('\\').append(ch);
            } else if (ch == '*') {
                if (i + 1 < antPattern.length() && antPattern.charAt(i + 1) == '*') {
                    if (i + 2 < antPattern.length() && WildcardPattern.isSlash(antPattern.charAt(i + 2))) {
                        sb.append("(?:.*").append(escapedDirectorySeparator).append("|)");
                        i += 2;
                    } else {
                        sb.append(".*");
                        ++i;
                    }
                } else {
                    sb.append("[^").append(escapedDirectorySeparator).append("]*?");
                }
            } else if (ch == '?') {
                sb.append("[^").append(escapedDirectorySeparator).append("]");
            } else if (WildcardPattern.isSlash(ch)) {
                sb.append(escapedDirectorySeparator);
            } else {
                sb.append(ch);
            }
            ++i;
        }
        sb.append('$');
        return sb.toString();
    }

    private static boolean isSlash(char ch) {
        return ch == '/' || ch == '\\';
    }

    public String toString() {
        return this.stringRepresentation;
    }

    public boolean match(String value) {
        value = StringUtils.removeStart(value, "/");
        value = StringUtils.removeEnd(value, "/");
        return this.pattern.matcher(value).matches();
    }

    public static boolean match(WildcardPattern[] patterns, String value) {
        for (WildcardPattern pattern : patterns) {
            if (!pattern.match(value)) continue;
            return true;
        }
        return false;
    }

    public static WildcardPattern create(String pattern) {
        return WildcardPattern.create(pattern, "/");
    }

    public static WildcardPattern[] create(@Nullable String[] patterns) {
        if (patterns == null) {
            return new WildcardPattern[0];
        }
        WildcardPattern[] exclusionPAtterns = new WildcardPattern[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            exclusionPAtterns[i] = WildcardPattern.create(patterns[i]);
        }
        return exclusionPAtterns;
    }

    public static WildcardPattern create(String pattern, String directorySeparator) {
        String key = pattern + directorySeparator;
        WildcardPattern wildcardPattern = CACHE.get(key);
        if (wildcardPattern == null) {
            wildcardPattern = new WildcardPattern(pattern, directorySeparator);
            CACHE.put(key, wildcardPattern);
        }
        return wildcardPattern;
    }
}

