/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.web.page;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;

public final class Page {
    private final String key;
    private final String name;
    private final boolean isAdmin;
    private final Scope scope;
    private final Set<Qualifier> qualifiers;

    private Page(Builder builder) {
        this.key = builder.key;
        this.name = builder.name;
        this.qualifiers = Collections.unmodifiableSet(Stream.of(builder.qualifiers).sorted().collect(Collectors.toSet()));
        this.isAdmin = builder.isAdmin;
        this.scope = builder.scope;
    }

    public static Builder builder(String key) {
        return new Builder(key);
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public Set<Qualifier> getComponentQualifiers() {
        return this.qualifiers;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public Scope getScope() {
        return this.scope;
    }

    public static class Builder {
        private final String key;
        private String name;
        private boolean isAdmin = false;
        private Scope scope = Scope.GLOBAL;
        private Qualifier[] qualifiers = new Qualifier[0];

        private Builder(String key) {
            this.key = Objects.requireNonNull(key, "Key must not be null");
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setAdmin(boolean admin) {
            this.isAdmin = admin;
            return this;
        }

        public Builder setScope(Scope scope) {
            this.scope = Objects.requireNonNull(scope, "Scope must not be null");
            return this;
        }

        public Builder setComponentQualifiers(Qualifier ... qualifiers) {
            this.qualifiers = Objects.requireNonNull(qualifiers);
            return this;
        }

        public Page build() {
            if (this.key == null || this.key.isEmpty()) {
                throw new IllegalArgumentException("Key must not be empty");
            }
            if (this.name == null || this.name.isEmpty()) {
                throw new IllegalArgumentException("Name must be defined and not empty");
            }
            if (this.qualifiers.length > 0 && Scope.GLOBAL.equals((Object)this.scope)) {
                throw new IllegalArgumentException(String.format("The scope must be '%s' when component qualifiers are provided", new Object[]{Scope.COMPONENT}));
            }
            if (this.qualifiers.length == 0 && Scope.COMPONENT.equals((Object)this.scope)) {
                this.qualifiers = Qualifier.values();
            }
            return new Page(this);
        }
    }

    public static enum Qualifier {
        PROJECT("TRK"),
        MODULE("BRC"),
        VIEW("VW"),
        SUB_VIEW("SVW");

        private final String key;

        private Qualifier(String key) {
            this.key = key;
        }

        @CheckForNull
        public static Qualifier fromKey(String key) {
            return Arrays.stream(Qualifier.values()).filter(qualifier -> qualifier.key.equals(key)).findAny().orElse(null);
        }

        public String getKey() {
            return this.key;
        }
    }

    public static enum Scope {
        GLOBAL,
        COMPONENT;

    }
}

