/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.graph.DirectedGraphAccessor;
import org.sonar.graph.Edge;
import org.sonar.graph.EdgeFactory;
import org.sonar.graph.StringEdge;
import org.sonar.graph.StringEdgeFactory;

public class DirectedGraph<V, E extends Edge<V>>
implements DirectedGraphAccessor<V, E> {
    private EdgeFactory<V, E> edgeFactory;
    private Map<V, Map<V, E>> outgoingEdgesByVertex = new HashMap<V, Map<V, E>>();
    private Map<V, Map<V, E>> incomingEdgesByVertex = new HashMap<V, Map<V, E>>();
    private Set<V> vertices = new LinkedHashSet<V>();

    public DirectedGraph() {
    }

    public DirectedGraph(EdgeFactory<V, E> edgeFactory) {
        this.edgeFactory = edgeFactory;
    }

    public static DirectedGraph<String, StringEdge> createStringDirectedGraph() {
        return new DirectedGraph<String, StringEdge>(new StringEdgeFactory());
    }

    public DirectedGraph<V, E> addEdge(V from, V to) {
        this.checkEdgeFacory();
        Edge edge = (Edge)this.edgeFactory.createEdge(from, to);
        return this.addEdge(edge);
    }

    public DirectedGraph<V, E> addEdge(V from, V to, int weight) {
        this.checkEdgeFacory();
        Edge edge = (Edge)this.edgeFactory.createEdge(from, to, weight);
        return this.addEdge(edge);
    }

    private void checkEdgeFacory() {
        if (this.edgeFactory == null) {
            throw new IllegalStateException("EdgeFactory<V, E> has not been defined. Please use the 'public E addEdge(V from, V to, E edge)' method.");
        }
    }

    public DirectedGraph<V, E> addEdge(E edge) {
        this.addEdgeToMap(edge.getFrom(), edge.getTo(), edge, this.outgoingEdgesByVertex);
        this.addEdgeToMap(edge.getTo(), edge.getFrom(), edge, this.incomingEdgesByVertex);
        this.vertices.add(edge.getFrom());
        this.vertices.add(edge.getTo());
        return this;
    }

    private void addEdgeToMap(V vertexKey1, V vertexKey2, E edge, Map<V, Map<V, E>> edgesByVertex) {
        Map<E, E> edges = edgesByVertex.get(vertexKey1);
        if (edges == null) {
            edges = new HashMap<V, E>();
            edgesByVertex.put((Map<E, E>)vertexKey1, (Map<Map<E, E>, E>)edges);
        }
        if (edges.containsKey(vertexKey2)) {
            throw new IllegalStateException("The graph already contains the edge : " + edge);
        }
        edges.put(vertexKey2, edge);
    }

    @Override
    public E getEdge(V from, V to) {
        Map<V, E> outgoingEdgesFrom = this.outgoingEdgesByVertex.get(from);
        if (outgoingEdgesFrom == null) {
            return null;
        }
        return (E)((Edge)outgoingEdgesFrom.get(to));
    }

    @Override
    public boolean hasEdge(V from, V to) {
        Map<V, E> outgoingEdges = this.outgoingEdgesByVertex.get(from);
        if (outgoingEdges == null) {
            return false;
        }
        return outgoingEdges.containsKey(to);
    }

    public void addVertex(V vertex) {
        this.vertices.add(vertex);
    }

    public void addVertices(Collection<V> vertices) {
        for (V vertex : vertices) {
            this.addVertex(vertex);
        }
    }

    @Override
    public Set<V> getVertices() {
        return this.vertices;
    }

    public List<E> getEdges(Collection<V> vertices) {
        ArrayList<E> result = new ArrayList<E>();
        for (V vertice : vertices) {
            Collection<E> outgoingEdges = this.getOutgoingEdges(vertice);
            if (outgoingEdges == null) continue;
            result.addAll(outgoingEdges);
        }
        return result;
    }

    @Override
    public Collection<E> getOutgoingEdges(V from) {
        Map<V, E> outgoingEdges = this.outgoingEdgesByVertex.get(from);
        if (outgoingEdges == null) {
            return new LinkedHashSet();
        }
        return outgoingEdges.values();
    }

    @Override
    public Collection<E> getIncomingEdges(V to) {
        Map<V, E> incomingEdges = this.incomingEdgesByVertex.get(to);
        if (incomingEdges == null) {
            return new LinkedHashSet();
        }
        return incomingEdges.values();
    }
}

