/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.mcp.server;

import io.modelcontextprotocol.server.McpAsyncServer;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.server.transport.StdioServerTransport;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.ServerMcpTransport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.ai.autoconfigure.mcp.server.McpServerProperties;
import org.springframework.ai.autoconfigure.mcp.server.MpcWebFluxServerAutoConfiguration;
import org.springframework.ai.autoconfigure.mcp.server.MpcWebMvcServerAutoConfiguration;
import org.springframework.ai.mcp.McpToolUtils;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.log.LogAccessor;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Mono;

@AutoConfiguration(after={MpcWebMvcServerAutoConfiguration.class, MpcWebFluxServerAutoConfiguration.class})
@ConditionalOnClass(value={McpSchema.class, McpSyncServer.class})
@EnableConfigurationProperties(value={McpServerProperties.class})
@ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class MpcServerAutoConfiguration {
    private static final LogAccessor logger = new LogAccessor(MpcServerAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public ServerMcpTransport stdioServerTransport() {
        return new StdioServerTransport();
    }

    @Bean
    @ConditionalOnMissingBean
    public McpSchema.ServerCapabilities.Builder capabilitiesBuilder() {
        return McpSchema.ServerCapabilities.builder();
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    public List<McpServerFeatures.SyncToolRegistration> syncTools(ObjectProvider<List<ToolCallback>> toolCalls) {
        List tools = toolCalls.stream().flatMap(Collection::stream).toList();
        return McpToolUtils.toSyncToolRegistration(tools);
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    public McpSyncServer mcpSyncServer(ServerMcpTransport transport, McpSchema.ServerCapabilities.Builder capabilitiesBuilder, McpServerProperties serverProperties, ObjectProvider<List<McpServerFeatures.SyncToolRegistration>> tools, ObjectProvider<List<McpServerFeatures.SyncResourceRegistration>> resources, ObjectProvider<List<McpServerFeatures.SyncPromptRegistration>> prompts, ObjectProvider<Consumer<List<McpSchema.Root>>> rootsChangeConsumers, List<ToolCallbackProvider> toolCallbackProvider) {
        List promptResgistrations;
        List resourceResgistrations;
        McpSchema.Implementation serverInfo = new McpSchema.Implementation(serverProperties.getName(), serverProperties.getVersion());
        McpServer.SyncSpec serverBuilder = McpServer.sync((ServerMcpTransport)transport).serverInfo(serverInfo);
        ArrayList toolResgistrations = new ArrayList(tools.stream().flatMap(Collection::stream).toList());
        List<ToolCallback> providerToolCallbacks = toolCallbackProvider.stream().map(pr -> List.of(pr.getToolCallbacks())).flatMap(Collection::stream).filter(fc -> fc instanceof ToolCallback).map(fc -> (ToolCallback)fc).toList();
        toolResgistrations.addAll(McpToolUtils.toSyncToolRegistration(providerToolCallbacks));
        if (!CollectionUtils.isEmpty(toolResgistrations)) {
            serverBuilder.tools(toolResgistrations);
            capabilitiesBuilder.tools(Boolean.valueOf(serverProperties.isToolChangeNotification()));
            logger.info((CharSequence)("Registered tools" + toolResgistrations.size() + " notification: " + serverProperties.isToolChangeNotification()));
        }
        if (!CollectionUtils.isEmpty(resourceResgistrations = resources.stream().flatMap(Collection::stream).toList())) {
            serverBuilder.resources(resourceResgistrations);
            capabilitiesBuilder.resources(Boolean.valueOf(false), Boolean.valueOf(serverProperties.isResourceChangeNotification()));
            logger.info((CharSequence)("Registered resources" + resourceResgistrations.size() + " notification: " + serverProperties.isResourceChangeNotification()));
        }
        if (!CollectionUtils.isEmpty(promptResgistrations = prompts.stream().flatMap(Collection::stream).toList())) {
            serverBuilder.prompts(promptResgistrations);
            capabilitiesBuilder.prompts(Boolean.valueOf(serverProperties.isPromptChangeNotification()));
            logger.info((CharSequence)("Registered prompts" + promptResgistrations.size() + " notification: " + serverProperties.isPromptChangeNotification()));
        }
        rootsChangeConsumers.ifAvailable(consumer -> {
            serverBuilder.rootsChangeConsumer(consumer);
            logger.info((CharSequence)"Registered roots change consumer");
        });
        serverBuilder.capabilities(capabilitiesBuilder.build());
        return serverBuilder.build();
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"type"}, havingValue="ASYNC")
    public List<McpServerFeatures.AsyncToolRegistration> asyncTools(ObjectProvider<List<ToolCallback>> toolCalls) {
        List tools = toolCalls.stream().flatMap(Collection::stream).toList();
        return McpToolUtils.toAsyncToolRegistration(tools);
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"type"}, havingValue="ASYNC")
    public McpAsyncServer mcpAsyncServer(ServerMcpTransport transport, McpSchema.ServerCapabilities.Builder capabilitiesBuilder, McpServerProperties serverProperties, ObjectProvider<List<McpServerFeatures.AsyncToolRegistration>> tools, ObjectProvider<List<McpServerFeatures.AsyncResourceRegistration>> resources, ObjectProvider<List<McpServerFeatures.AsyncPromptRegistration>> prompts, ObjectProvider<Consumer<List<McpSchema.Root>>> rootsChangeConsumer, List<ToolCallbackProvider> toolCallbackProvider) {
        List promptResgistrations;
        List resourceResgistrations;
        McpSchema.Implementation serverInfo = new McpSchema.Implementation(serverProperties.getName(), serverProperties.getVersion());
        McpServer.AsyncSpec serverBilder = McpServer.async((ServerMcpTransport)transport).serverInfo(serverInfo);
        ArrayList toolResgistrations = new ArrayList(tools.stream().flatMap(Collection::stream).toList());
        List<ToolCallback> providerToolCallbacks = toolCallbackProvider.stream().map(pr -> List.of(pr.getToolCallbacks())).flatMap(Collection::stream).filter(fc -> fc instanceof ToolCallback).map(fc -> (ToolCallback)fc).toList();
        toolResgistrations.addAll(McpToolUtils.toAsyncToolRegistration(providerToolCallbacks));
        if (!CollectionUtils.isEmpty(toolResgistrations)) {
            serverBilder.tools(toolResgistrations);
            capabilitiesBuilder.tools(Boolean.valueOf(serverProperties.isToolChangeNotification()));
            logger.info((CharSequence)("Registered tools" + toolResgistrations.size() + " notification: " + serverProperties.isToolChangeNotification()));
        }
        if (!CollectionUtils.isEmpty(resourceResgistrations = resources.stream().flatMap(Collection::stream).toList())) {
            serverBilder.resources(resourceResgistrations);
            capabilitiesBuilder.resources(Boolean.valueOf(false), Boolean.valueOf(serverProperties.isResourceChangeNotification()));
            logger.info((CharSequence)("Registered resources" + resourceResgistrations.size() + " notification: " + serverProperties.isResourceChangeNotification()));
        }
        if (!CollectionUtils.isEmpty(promptResgistrations = prompts.stream().flatMap(Collection::stream).toList())) {
            serverBilder.prompts(promptResgistrations);
            capabilitiesBuilder.prompts(Boolean.valueOf(serverProperties.isPromptChangeNotification()));
            logger.info((CharSequence)("Registered prompts" + promptResgistrations.size() + " notification: " + serverProperties.isPromptChangeNotification()));
        }
        rootsChangeConsumer.ifAvailable(consumer -> {
            Function<List, Mono> asyncConsumer = roots -> {
                consumer.accept(roots);
                return Mono.empty();
            };
            serverBilder.rootsChangeConsumer(asyncConsumer);
            logger.info((CharSequence)"Registered roots change consumer");
        });
        serverBilder.capabilities(capabilitiesBuilder.build());
        return serverBilder.build();
    }
}

