/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.repackage;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.springframework.boot.gradle.SpringBootPluginExtension;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.LibraryCallback;
import org.springframework.boot.loader.tools.LibraryScope;

class ProjectLibraries
implements Libraries {
    private final Project project;
    private final SpringBootPluginExtension extension;
    private final boolean excludeDevtools;
    private String providedConfigurationName = "providedRuntime";
    private String customConfigurationName = null;

    ProjectLibraries(Project project, SpringBootPluginExtension extension, boolean excludeDevTools) {
        this.project = project;
        this.extension = extension;
        this.excludeDevtools = excludeDevTools;
    }

    public void setProvidedConfigurationName(String providedConfigurationName) {
        this.providedConfigurationName = providedConfigurationName;
    }

    public void setCustomConfigurationName(String customConfigurationName) {
        this.customConfigurationName = customConfigurationName;
    }

    public void doWithLibraries(LibraryCallback callback) throws IOException {
        Set<GradleLibrary> custom = this.getLibraries(this.customConfigurationName, LibraryScope.CUSTOM);
        if (custom != null) {
            this.libraries(custom, callback);
        } else {
            Set<GradleLibrary> compile = this.getLibraries("compile", LibraryScope.COMPILE);
            Set<GradleLibrary> runtime = this.getLibraries("runtime", LibraryScope.RUNTIME);
            runtime = this.minus(runtime, compile);
            Set<GradleLibrary> provided = this.getLibraries(this.providedConfigurationName, LibraryScope.PROVIDED);
            if (provided != null) {
                compile = this.minus(compile, provided);
                runtime = this.minus(runtime, provided);
            }
            this.libraries(compile, callback);
            this.libraries(runtime, callback);
            this.libraries(provided, callback);
        }
    }

    private Set<GradleLibrary> getLibraries(String configurationName, LibraryScope scope) {
        Configuration configuration;
        Configuration configuration2 = configuration = configurationName == null ? null : (Configuration)this.project.getConfigurations().findByName(configurationName);
        if (configuration == null) {
            return null;
        }
        LinkedHashSet<GradleLibrary> libraries = new LinkedHashSet<GradleLibrary>();
        for (ResolvedArtifact artifact : configuration.getResolvedConfiguration().getResolvedArtifacts()) {
            libraries.add(new ResolvedArtifactLibrary(artifact, scope));
        }
        libraries.addAll(this.getLibrariesForFileDependencies(configuration, scope));
        return libraries;
    }

    private Set<GradleLibrary> getLibrariesForFileDependencies(Configuration configuration, LibraryScope scope) {
        LinkedHashSet<GradleLibrary> libraries = new LinkedHashSet<GradleLibrary>();
        for (Dependency dependency : configuration.getIncoming().getDependencies()) {
            if (dependency instanceof FileCollectionDependency) {
                FileCollectionDependency fileDependency = (FileCollectionDependency)dependency;
                for (File file : fileDependency.resolve()) {
                    libraries.add(new GradleLibrary(fileDependency.getGroup(), file, scope));
                }
                continue;
            }
            if (!(dependency instanceof ProjectDependency)) continue;
            ProjectDependency projectDependency = (ProjectDependency)dependency;
            libraries.addAll(this.getLibrariesForFileDependencies(projectDependency.getProjectConfiguration(), scope));
        }
        return libraries;
    }

    private Set<GradleLibrary> minus(Set<GradleLibrary> source, Set<GradleLibrary> toRemove) {
        if (source == null || toRemove == null) {
            return source;
        }
        HashSet<File> filesToRemove = new HashSet<File>();
        for (GradleLibrary library : toRemove) {
            filesToRemove.add(library.getFile());
        }
        LinkedHashSet<GradleLibrary> result = new LinkedHashSet<GradleLibrary>();
        for (GradleLibrary library : source) {
            if (filesToRemove.contains(library.getFile())) continue;
            result.add(library);
        }
        return result;
    }

    private void libraries(Set<GradleLibrary> libraries, LibraryCallback callback) throws IOException {
        if (libraries != null) {
            Set<String> duplicates = this.getDuplicates(libraries);
            for (GradleLibrary library : libraries) {
                if (this.isExcluded(library)) continue;
                library.setIncludeGroupName(duplicates.contains(library.getName()));
                callback.library((Library)library);
            }
        }
    }

    private boolean isExcluded(GradleLibrary library) {
        return this.excludeDevtools && this.isDevToolsJar(library);
    }

    private boolean isDevToolsJar(GradleLibrary library) {
        return "org.springframework.boot".equals(library.getGroup()) && library.getName().startsWith("spring-boot-devtools");
    }

    private Set<String> getDuplicates(Set<GradleLibrary> libraries) {
        HashSet<String> duplicates = new HashSet<String>();
        HashSet<String> seen = new HashSet<String>();
        for (GradleLibrary library : libraries) {
            if (library.getFile() == null || seen.add(library.getFile().getName())) continue;
            duplicates.add(library.getFile().getName());
        }
        return duplicates;
    }

    private class ResolvedArtifactLibrary
    extends GradleLibrary {
        private final ResolvedArtifact artifact;

        ResolvedArtifactLibrary(ResolvedArtifact artifact, LibraryScope scope) {
            super(artifact.getModuleVersion().getId().getGroup(), artifact.getFile(), scope);
            this.artifact = artifact;
        }

        public boolean isUnpackRequired() {
            if (ProjectLibraries.this.extension.getRequiresUnpack() != null) {
                ModuleVersionIdentifier id = this.artifact.getModuleVersion().getId();
                return ProjectLibraries.this.extension.getRequiresUnpack().contains(id.getGroup() + ":" + id.getName());
            }
            return false;
        }
    }

    private class GradleLibrary
    extends Library {
        private final String group;
        private boolean includeGroupName;

        GradleLibrary(String group, File file, LibraryScope scope) {
            super(file, scope);
            this.group = group;
        }

        public void setIncludeGroupName(boolean includeGroupName) {
            this.includeGroupName = includeGroupName;
        }

        public String getGroup() {
            return this.group;
        }

        public String getName() {
            String name = super.getName();
            if (this.includeGroupName && this.group != null) {
                name = this.group + "-" + name;
            }
            return name;
        }

        public int hashCode() {
            return this.getFile().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof GradleLibrary) {
                return this.getFile().equals(((GradleLibrary)((Object)obj)).getFile());
            }
            return false;
        }

        public String toString() {
            return this.getFile().getAbsolutePath();
        }
    }
}

