/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.util.ContextInitializer;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.slf4j.impl.StaticLoggerBinder;
import org.springframework.boot.logging.AbstractLoggingSystem;
import org.springframework.boot.logging.LogLevel;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;

public class LogbackLoggingSystem
extends AbstractLoggingSystem {
    private static final Map<LogLevel, Level> LEVELS;

    public LogbackLoggingSystem(ClassLoader classLoader) {
        super(classLoader, "logback-test.groovy", "logback-test.xml", "logback.groovy", "logback.xml");
    }

    @Override
    public void beforeInitialize() {
        super.beforeInitialize();
        this.configureJdkLoggingBridgeHandler();
        this.configureJBossLoggingToUseSlf4j();
    }

    @Override
    public void cleanUp() {
        this.removeJdkLoggingBridgeHandler();
    }

    private void configureJdkLoggingBridgeHandler() {
        try {
            if (this.bridgeHandlerIsAvailable()) {
                this.removeJdkLoggingBridgeHandler();
                SLF4JBridgeHandler.install();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean bridgeHandlerIsAvailable() {
        return ClassUtils.isPresent((String)"org.slf4j.bridge.SLF4JBridgeHandler", (ClassLoader)this.getClassLoader());
    }

    private void configureJBossLoggingToUseSlf4j() {
        System.setProperty("org.jboss.logging.provider", "slf4j");
    }

    private void removeJdkLoggingBridgeHandler() {
        try {
            if (this.bridgeHandlerIsAvailable()) {
                try {
                    SLF4JBridgeHandler.removeHandlersForRootLogger();
                }
                catch (NoSuchMethodError ex) {
                    SLF4JBridgeHandler.uninstall();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void initialize(String configLocation) {
        Assert.notNull((Object)configLocation, (String)"ConfigLocation must not be null");
        String resolvedLocation = SystemPropertyUtils.resolvePlaceholders((String)configLocation);
        ILoggerFactory factory = StaticLoggerBinder.getSingleton().getLoggerFactory();
        Assert.isInstanceOf(LoggerContext.class, (Object)factory, (String)String.format("LoggerFactory is not a Logback LoggerContext but Logback is on the classpath. Either remove Logback or the competing implementation (%s loaded from %s).", factory.getClass(), this.getLocation(factory)));
        LoggerContext context = (LoggerContext)factory;
        context.stop();
        context.reset();
        try {
            URL url = ResourceUtils.getURL((String)resolvedLocation);
            new ContextInitializer(context).configureByResource(url);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialize logging from " + configLocation, ex);
        }
    }

    private Object getLocation(ILoggerFactory factory) {
        try {
            ProtectionDomain protectionDomain = factory.getClass().getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            if (codeSource != null) {
                return codeSource.getLocation();
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return "unknown location";
    }

    @Override
    public void setLogLevel(String loggerName, LogLevel level) {
        ILoggerFactory factory = StaticLoggerBinder.getSingleton().getLoggerFactory();
        Logger logger = factory.getLogger(StringUtils.isEmpty((Object)loggerName) ? "ROOT" : loggerName);
        ((ch.qos.logback.classic.Logger)logger).setLevel(LEVELS.get((Object)level));
    }

    static {
        HashMap<LogLevel, Level> levels = new HashMap<LogLevel, Level>();
        levels.put(LogLevel.TRACE, Level.TRACE);
        levels.put(LogLevel.DEBUG, Level.DEBUG);
        levels.put(LogLevel.INFO, Level.INFO);
        levels.put(LogLevel.WARN, Level.WARN);
        levels.put(LogLevel.ERROR, Level.ERROR);
        levels.put(LogLevel.FATAL, Level.ERROR);
        levels.put(LogLevel.OFF, Level.OFF);
        LEVELS = Collections.unmodifiableMap(levels);
    }
}

