/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.flux;

import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.web.FunctionHttpProperties;
import org.springframework.cloud.function.web.constants.WebRequestConstants;
import org.springframework.cloud.function.web.util.FunctionWebRequestProcessingHelper;
import org.springframework.cloud.function.web.util.FunctionWrapper;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.multipart.FormFieldPart;
import org.springframework.http.codec.multipart.Part;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
@EnableConfigurationProperties(value={FunctionHttpProperties.class})
public class FunctionController {
    private final FunctionHttpProperties functionHttpProperties;

    public FunctionController(FunctionHttpProperties functionHttpProperties) {
        this.functionHttpProperties = functionHttpProperties;
    }

    @PostMapping(path={"/**"}, consumes={"application/x-www-form-urlencoded"})
    @ResponseBody
    public Mono<ResponseEntity<?>> form(ServerWebExchange request) {
        FunctionWrapper wrapper = this.wrapper(request);
        if (FunctionWebRequestProcessingHelper.isFunctionValidForMethod("POST", wrapper.getFunction().getFunctionDefinition(), this.functionHttpProperties)) {
            return request.getFormData().doOnSuccess(params -> wrapper.getParams().addAll(params)).then(Mono.defer(() -> (Mono)FunctionWebRequestProcessingHelper.processRequest(wrapper, wrapper.getParams(), false)));
        }
        throw new IllegalArgumentException(FunctionWebRequestProcessingHelper.buildBadMappingErrorMessage("POST", wrapper.getFunction().getFunctionDefinition()));
    }

    @PostMapping(path={"/**"}, consumes={"multipart/form-data"})
    @ResponseBody
    public Mono<ResponseEntity<?>> multipart(ServerWebExchange request) {
        FunctionWrapper wrapper = this.wrapper(request);
        if (FunctionWebRequestProcessingHelper.isFunctionValidForMethod("POST", wrapper.getFunction().getFunctionDefinition(), this.functionHttpProperties)) {
            return request.getMultipartData().doOnSuccess(params -> wrapper.getParams().addAll(this.multi((MultiValueMap<String, Part>)params))).then(Mono.defer(() -> (Mono)FunctionWebRequestProcessingHelper.processRequest(wrapper, wrapper.getParams(), false)));
        }
        throw new IllegalArgumentException(FunctionWebRequestProcessingHelper.buildBadMappingErrorMessage("POST", wrapper.getFunction().getFunctionDefinition()));
    }

    @PostMapping(path={"/**"})
    @ResponseBody
    public Mono<ResponseEntity<?>> post(ServerWebExchange request, @RequestBody(required=false) String body) {
        FunctionWrapper wrapper = this.wrapper(request);
        if (FunctionWebRequestProcessingHelper.isFunctionValidForMethod("POST", wrapper.getFunction().getFunctionDefinition(), this.functionHttpProperties)) {
            return (Mono)FunctionWebRequestProcessingHelper.processRequest(wrapper, body, false);
        }
        throw new IllegalArgumentException(FunctionWebRequestProcessingHelper.buildBadMappingErrorMessage("POST", wrapper.getFunction().getFunctionDefinition()));
    }

    @PutMapping(path={"/**"})
    @ResponseBody
    public Mono<ResponseEntity<?>> put(ServerWebExchange request, @RequestBody(required=false) String body) {
        FunctionWrapper wrapper = this.wrapper(request);
        if (FunctionWebRequestProcessingHelper.isFunctionValidForMethod("PUT", wrapper.getFunction().getFunctionDefinition(), this.functionHttpProperties)) {
            return (Mono)FunctionWebRequestProcessingHelper.processRequest(wrapper, body, false);
        }
        throw new IllegalArgumentException(FunctionWebRequestProcessingHelper.buildBadMappingErrorMessage("PUT", wrapper.getFunction().getFunctionDefinition()));
    }

    @DeleteMapping(path={"/**"})
    @ResponseBody
    public Mono<ResponseEntity<?>> delete(ServerWebExchange request, @RequestBody(required=false) String body) {
        FunctionWrapper wrapper = this.wrapper(request);
        if (FunctionWebRequestProcessingHelper.isFunctionValidForMethod("DELETE", wrapper.getFunction().getFunctionDefinition(), this.functionHttpProperties)) {
            return (Mono)FunctionWebRequestProcessingHelper.processRequest(wrapper, body, false);
        }
        throw new IllegalArgumentException(FunctionWebRequestProcessingHelper.buildBadMappingErrorMessage("DELETE", wrapper.getFunction().getFunctionDefinition()));
    }

    @PostMapping(path={"/**"}, produces={"text/event-stream"})
    @ResponseBody
    public Publisher<?> postStream(ServerWebExchange request, @RequestBody(required=false) Flux<String> body) {
        FunctionWrapper wrapper = this.wrapper(request);
        if (FunctionWebRequestProcessingHelper.isFunctionValidForMethod("POST", wrapper.getFunction().getFunctionDefinition(), this.functionHttpProperties)) {
            return FunctionWebRequestProcessingHelper.processRequest(wrapper, body, true);
        }
        throw new IllegalArgumentException(FunctionWebRequestProcessingHelper.buildBadMappingErrorMessage("POST", wrapper.getFunction().getFunctionDefinition()));
    }

    @GetMapping(path={"/**"}, produces={"text/event-stream"})
    @ResponseBody
    public Publisher<?> getStream(ServerWebExchange request) {
        FunctionWrapper wrapper = this.wrapper(request);
        if (FunctionWebRequestProcessingHelper.isFunctionValidForMethod("GET", wrapper.getFunction().getFunctionDefinition(), this.functionHttpProperties)) {
            return FunctionWebRequestProcessingHelper.processRequest(wrapper, wrapper.getArgument(), true);
        }
        throw new IllegalArgumentException(FunctionWebRequestProcessingHelper.buildBadMappingErrorMessage("GET", wrapper.getFunction().getFunctionDefinition()));
    }

    @GetMapping(path={"/**"})
    @ResponseBody
    public Mono<ResponseEntity<?>> get(ServerWebExchange request) {
        FunctionWrapper wrapper = this.wrapper(request);
        if (FunctionWebRequestProcessingHelper.isFunctionValidForMethod("GET", wrapper.getFunction().getFunctionDefinition(), this.functionHttpProperties)) {
            return (Mono)FunctionWebRequestProcessingHelper.processRequest(wrapper, wrapper.getArgument(), false);
        }
        throw new IllegalArgumentException(FunctionWebRequestProcessingHelper.buildBadMappingErrorMessage("GET", wrapper.getFunction().getFunctionDefinition()));
    }

    private FunctionWrapper wrapper(ServerWebExchange request) {
        SimpleFunctionRegistry.FunctionInvocationWrapper function = (SimpleFunctionRegistry.FunctionInvocationWrapper)request.getAttribute(WebRequestConstants.HANDLER);
        HttpHeaders headers = HttpHeaders.writableHttpHeaders((HttpHeaders)request.getRequest().getHeaders());
        headers.set("uri", request.getRequest().getURI().toString());
        FunctionWrapper wrapper = new FunctionWrapper(function);
        wrapper.setHeaders(headers);
        wrapper.getParams().addAll(request.getRequest().getQueryParams());
        String argument = (String)request.getAttribute(WebRequestConstants.ARGUMENT);
        if (argument != null) {
            wrapper.setArgument(argument);
        }
        return wrapper;
    }

    private MultiValueMap<String, String> multi(MultiValueMap<String, Part> body) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        for (String key : body.keySet()) {
            for (Part part : (List)body.get((Object)key)) {
                if (!(part instanceof FormFieldPart)) continue;
                FormFieldPart form = (FormFieldPart)part;
                map.add((Object)key, (Object)form.value());
            }
        }
        return map;
    }
}

