/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.mvc;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.web.FunctionHttpProperties;
import org.springframework.cloud.function.web.constants.WebRequestConstants;
import org.springframework.cloud.function.web.util.FunctionWebRequestProcessingHelper;
import org.springframework.cloud.function.web.util.FunctionWrapper;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
@EnableConfigurationProperties(value={FunctionHttpProperties.class})
public class FunctionController {
    private final FunctionHttpProperties functionHttpProperties;

    public FunctionController(FunctionHttpProperties functionHttpProperties) {
        this.functionHttpProperties = functionHttpProperties;
    }

    @PostMapping(path={"/**"}, consumes={"application/x-www-form-urlencoded", "multipart/form-data"})
    @ResponseBody
    public Object form(WebRequest request) {
        FunctionWrapper wrapper = this.wrapper(request);
        if (FunctionWebRequestProcessingHelper.isFunctionValidForMethod("POST", wrapper.getFunction().getFunctionDefinition(), this.functionHttpProperties)) {
            MultiValueMap multiFileMap;
            if (((ServletWebRequest)request).getRequest() instanceof StandardMultipartHttpServletRequest && !CollectionUtils.isEmpty((Map)(multiFileMap = ((StandardMultipartHttpServletRequest)((ServletWebRequest)request).getRequest()).getMultiFileMap()))) {
                List files = multiFileMap.values().stream().flatMap(v -> v.stream()).map(file -> MessageBuilder.withPayload((Object)file).copyHeaders((Map)wrapper.getHeaders()).build()).collect(Collectors.toList());
                SimpleFunctionRegistry.FunctionInvocationWrapper function = wrapper.getFunction();
                Publisher result = (Publisher)function.apply((Object)Flux.fromIterable(files));
                ResponseEntity.BodyBuilder builder = ResponseEntity.ok();
                if (result instanceof Flux) {
                    result = Flux.from((Publisher)result).map(message -> message instanceof Message ? ((Message)message).getPayload() : message).collectList();
                }
                return Mono.from((Publisher)result).flatMap(body -> Mono.just((Object)builder.body(body)));
            }
            return FunctionWebRequestProcessingHelper.processRequest(wrapper, wrapper.getParams(), false);
        }
        throw new IllegalArgumentException(FunctionWebRequestProcessingHelper.buildBadMappingErrorMessage("POST", wrapper.getFunction().getFunctionDefinition()));
    }

    @PostMapping(path={"/**"}, produces={"text/event-stream"})
    @ResponseBody
    public Mono<ResponseEntity<Publisher<?>>> postStream(WebRequest request, @RequestBody(required=false) String body) {
        String argument = StringUtils.hasText((String)body) ? body : "";
        FunctionWrapper wrapper = this.wrapper(request);
        if (FunctionWebRequestProcessingHelper.isFunctionValidForMethod("POST", wrapper.getFunction().getFunctionDefinition(), this.functionHttpProperties)) {
            return ((Mono)FunctionWebRequestProcessingHelper.processRequest(wrapper, argument, true)).map(response -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(response.getHeaders())).body((Object)((Publisher)response.getBody())));
        }
        throw new IllegalArgumentException(FunctionWebRequestProcessingHelper.buildBadMappingErrorMessage("POST", wrapper.getFunction().getFunctionDefinition()));
    }

    @GetMapping(path={"/**"}, produces={"text/event-stream"})
    @ResponseBody
    public Publisher<?> getStream(WebRequest request) {
        FunctionWrapper wrapper = this.wrapper(request);
        if (FunctionWebRequestProcessingHelper.isFunctionValidForMethod("GET", wrapper.getFunction().getFunctionDefinition(), this.functionHttpProperties)) {
            return FunctionWebRequestProcessingHelper.processRequest(wrapper, wrapper.getArgument(), true);
        }
        throw new IllegalArgumentException(FunctionWebRequestProcessingHelper.buildBadMappingErrorMessage("GET", wrapper.getFunction().getFunctionDefinition()));
    }

    @PostMapping(path={"/**"})
    @ResponseBody
    public Object post(WebRequest request, @RequestBody(required=false) String body) {
        FunctionWrapper wrapper = this.wrapper(request);
        if (FunctionWebRequestProcessingHelper.isFunctionValidForMethod("POST", wrapper.getFunction().getFunctionDefinition(), this.functionHttpProperties)) {
            Assert.isTrue((!wrapper.getFunction().isSupplier() ? 1 : 0) != 0, (String)"'POST' can only be mapped to Function or Consumer");
            return FunctionWebRequestProcessingHelper.processRequest(wrapper, body, false);
        }
        throw new IllegalArgumentException(FunctionWebRequestProcessingHelper.buildBadMappingErrorMessage("POST", wrapper.getFunction().getFunctionDefinition()));
    }

    @PutMapping(path={"/**"})
    @ResponseBody
    public Object put(WebRequest request, @RequestBody(required=false) String body) {
        FunctionWrapper wrapper = this.wrapper(request);
        if (FunctionWebRequestProcessingHelper.isFunctionValidForMethod("PUT", wrapper.getFunction().getFunctionDefinition(), this.functionHttpProperties)) {
            return FunctionWebRequestProcessingHelper.processRequest(wrapper, body, false);
        }
        throw new IllegalArgumentException(FunctionWebRequestProcessingHelper.buildBadMappingErrorMessage("PUT", wrapper.getFunction().getFunctionDefinition()));
    }

    @DeleteMapping(path={"/**"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delete(WebRequest request, @RequestBody(required=false) String body) {
        FunctionWrapper wrapper = this.wrapper(request);
        if (!FunctionWebRequestProcessingHelper.isFunctionValidForMethod("DELETE", wrapper.getFunction().getFunctionDefinition(), this.functionHttpProperties)) {
            throw new IllegalArgumentException(FunctionWebRequestProcessingHelper.buildBadMappingErrorMessage("DELETE", wrapper.getFunction().getFunctionDefinition()));
        }
        Assert.isTrue((boolean)wrapper.getFunction().isConsumer(), (String)"'DELETE' can only be mapped to Consumer");
        FunctionWebRequestProcessingHelper.processRequest(wrapper, wrapper.getArgument(), false);
    }

    @GetMapping(path={"/**"})
    @ResponseBody
    public Object get(WebRequest request) {
        FunctionWrapper wrapper = this.wrapper(request);
        if (FunctionWebRequestProcessingHelper.isFunctionValidForMethod("GET", wrapper.getFunction().getFunctionDefinition(), this.functionHttpProperties)) {
            return FunctionWebRequestProcessingHelper.processRequest(wrapper, wrapper.getArgument(), false);
        }
        throw new IllegalArgumentException(FunctionWebRequestProcessingHelper.buildBadMappingErrorMessage("GET", wrapper.getFunction().getFunctionDefinition()));
    }

    private FunctionWrapper wrapper(WebRequest request) {
        SimpleFunctionRegistry.FunctionInvocationWrapper function = (SimpleFunctionRegistry.FunctionInvocationWrapper)request.getAttribute(WebRequestConstants.HANDLER, 0);
        FunctionWrapper wrapper = new FunctionWrapper(function, ((ServletWebRequest)request).getRequest().getMethod());
        for (String key : request.getParameterMap().keySet()) {
            wrapper.getParams().addAll((Object)key, Arrays.asList(request.getParameterValues(key)));
        }
        Iterator keys = request.getHeaderNames();
        while (keys.hasNext()) {
            String key;
            key = (String)keys.next();
            wrapper.getHeaders().addAll(key, Arrays.asList(request.getHeaderValues(key)));
        }
        HttpHeaders headers = HttpHeaders.writableHttpHeaders((HttpHeaders)wrapper.getHeaders());
        headers.set("uri", ((ServletWebRequest)request).getRequest().getRequestURI());
        String argument = (String)request.getAttribute(WebRequestConstants.ARGUMENT, 0);
        if (argument != null) {
            wrapper.setArgument(argument);
        }
        return wrapper;
    }
}

